/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.reactive.runtime;

import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import io.quarkus.arc.Arc;
import io.quarkus.mongodb.panache.MongoEntity;
import io.quarkus.mongodb.panache.binder.NativeQueryBinder;
import io.quarkus.mongodb.panache.binder.PanacheQlQueryBinder;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheQuery;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheUpdate;
import io.quarkus.mongodb.panache.reactive.runtime.ReactivePanacheQueryImpl;
import io.quarkus.mongodb.panache.reactive.runtime.ReactivePanacheUpdateImpl;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.reactive.ReactiveMongoCollection;
import io.quarkus.mongodb.reactive.ReactiveMongoDatabase;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.Bean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class ReactiveMongoOperations {
    private static final Logger LOGGER = Logger.getLogger(ReactiveMongoOperations.class);
    public static final String ID = "_id";
    public static final String MONGODB_DATABASE = "quarkus.mongodb.database";

    public static Uni<Void> persist(Object entity) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entity);
        return ReactiveMongoOperations.persist(collection, entity);
    }

    public static Uni<Void> persist(Iterable<?> entities) {
        return Uni.createFrom().deferred(() -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object entity : entities) {
                objects.add(entity);
            }
            if (objects.size() > 0) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
                return ReactiveMongoOperations.persist(collection, objects);
            }
            return ReactiveMongoOperations.nullUni();
        });
    }

    public static Uni<Void> persist(Object firstEntity, Object ... entities) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            return ReactiveMongoOperations.persist(collection, firstEntity);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        entityList.add(firstEntity);
        entityList.addAll(Arrays.asList(entities));
        return ReactiveMongoOperations.persist(collection, entityList);
    }

    public static Uni<Void> persist(Stream<?> entities) {
        return Uni.createFrom().deferred(() -> {
            List<Object> objects = entities.collect(Collectors.toList());
            if (objects.size() > 0) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
                return ReactiveMongoOperations.persist(collection, objects);
            }
            return ReactiveMongoOperations.nullUni();
        });
    }

    public static Uni<Void> update(Object entity) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entity);
        return ReactiveMongoOperations.update(collection, entity);
    }

    public static Uni<Void> update(Iterable<?> entities) {
        return Uni.createFrom().deferred(() -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object entity : entities) {
                objects.add(entity);
            }
            if (objects.size() > 0) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
                return ReactiveMongoOperations.update(collection, objects);
            }
            return ReactiveMongoOperations.nullUni();
        });
    }

    public static Uni<Void> update(Object firstEntity, Object ... entities) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            return ReactiveMongoOperations.update(collection, firstEntity);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        entityList.add(firstEntity);
        entityList.addAll(Arrays.asList(entities));
        return ReactiveMongoOperations.update(collection, entityList);
    }

    public static Uni<Void> update(Stream<?> entities) {
        return Uni.createFrom().deferred(() -> {
            List<Object> objects = entities.collect(Collectors.toList());
            if (objects.size() > 0) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
                return ReactiveMongoOperations.update(collection, objects);
            }
            return ReactiveMongoOperations.nullUni();
        });
    }

    public static Uni<Void> persistOrUpdate(Object entity) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entity);
        return ReactiveMongoOperations.persistOrUpdate(collection, entity);
    }

    public static Uni<Void> persistOrUpdate(Iterable<?> entities) {
        return Uni.createFrom().deferred(() -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object entity : entities) {
                objects.add(entity);
            }
            if (objects.size() > 0) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
                return ReactiveMongoOperations.persistOrUpdate(collection, objects);
            }
            return ReactiveMongoOperations.nullUni();
        });
    }

    public static Uni<Void> persistOrUpdate(Object firstEntity, Object ... entities) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            return ReactiveMongoOperations.persistOrUpdate(collection, firstEntity);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        entityList.add(firstEntity);
        entityList.addAll(Arrays.asList(entities));
        return ReactiveMongoOperations.persistOrUpdate(collection, entityList);
    }

    public static Uni<Void> persistOrUpdate(Stream<?> entities) {
        return Uni.createFrom().deferred(() -> {
            List<Object> objects = entities.collect(Collectors.toList());
            if (objects.size() > 0) {
                Object firstEntity = objects.get(0);
                ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(firstEntity);
                return ReactiveMongoOperations.persistOrUpdate(collection, objects);
            }
            return ReactiveMongoOperations.nullUni();
        });
    }

    public static Uni<Void> delete(Object entity) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entity);
        BsonDocument document = ReactiveMongoOperations.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        BsonDocument query = new BsonDocument().append(ID, id);
        return collection.deleteOne((Bson)query).onItem().ignore().andContinueWithNull();
    }

    public static ReactiveMongoCollection mongoCollection(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        ReactiveMongoDatabase database = ReactiveMongoOperations.mongoDatabase(mongoEntity);
        if (mongoEntity != null && !mongoEntity.collection().isEmpty()) {
            return database.getCollection(mongoEntity.collection(), entityClass);
        }
        return database.getCollection(entityClass.getSimpleName(), entityClass);
    }

    public static ReactiveMongoDatabase mongoDatabase(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        return ReactiveMongoOperations.mongoDatabase(mongoEntity);
    }

    public static Uni<Void> nullUni() {
        return Uni.createFrom().item((Object)null);
    }

    private static Uni<Void> persist(ReactiveMongoCollection collection, Object entity) {
        return collection.insertOne(entity).onItem().ignore().andContinueWithNull();
    }

    private static Uni<Void> persist(ReactiveMongoCollection collection, List<Object> entities) {
        return collection.insertMany(entities).onItem().ignore().andContinueWithNull();
    }

    private static Uni<Void> update(ReactiveMongoCollection collection, Object entity) {
        BsonDocument document = ReactiveMongoOperations.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        BsonDocument query = new BsonDocument().append(ID, id);
        return collection.replaceOne((Bson)query, entity).onItem().ignore().andContinueWithNull();
    }

    private static Uni<Void> update(ReactiveMongoCollection collection, List<Object> entities) {
        List unis = entities.stream().map(entity -> ReactiveMongoOperations.update(collection, entity)).collect(Collectors.toList());
        return Uni.combine().all().unis(unis).combinedWith(u -> null);
    }

    private static Uni<Void> persistOrUpdate(ReactiveMongoCollection collection, Object entity) {
        BsonDocument document = ReactiveMongoOperations.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        if (id == null) {
            return collection.insertOne(entity).onItem().ignore().andContinueWithNull();
        }
        BsonDocument query = new BsonDocument().append(ID, id);
        return collection.replaceOne((Bson)query, entity, new ReplaceOptions().upsert(true)).onItem().ignore().andContinueWithNull();
    }

    private static Uni<Void> persistOrUpdate(ReactiveMongoCollection collection, List<Object> entities) {
        ArrayList<Object> bulk = new ArrayList<Object>();
        for (Object entity : entities) {
            BsonDocument document = ReactiveMongoOperations.getBsonDocument(collection, entity);
            BsonValue id = document.get((Object)ID);
            if (id == null) {
                bulk.add(new InsertOneModel(entity));
                continue;
            }
            BsonDocument query = new BsonDocument().append(ID, id);
            bulk.add(new ReplaceOneModel((Bson)query, entity, new ReplaceOptions().upsert(true)));
        }
        return collection.bulkWrite(bulk).onItem().ignore().andContinueWithNull();
    }

    private static BsonDocument getBsonDocument(ReactiveMongoCollection collection, Object entity) {
        BsonDocument document = new BsonDocument();
        Codec codec = collection.getCodecRegistry().get(entity.getClass());
        codec.encode((BsonWriter)new BsonDocumentWriter(document), entity, EncoderContext.builder().build());
        return document;
    }

    private static ReactiveMongoCollection mongoCollection(Object entity) {
        Class<?> entityClass = entity.getClass();
        return ReactiveMongoOperations.mongoCollection(entityClass);
    }

    private static ReactiveMongoDatabase mongoDatabase(MongoEntity entity) {
        ReactiveMongoClient mongoClient = ReactiveMongoOperations.mongoClient(entity);
        if (entity != null && !entity.database().isEmpty()) {
            return mongoClient.getDatabase(entity.database());
        }
        String databaseName = (String)ConfigProvider.getConfig().getValue(MONGODB_DATABASE, String.class);
        return mongoClient.getDatabase(databaseName);
    }

    private static ReactiveMongoClient mongoClient(MongoEntity entity) {
        if (entity != null && !entity.clientName().isEmpty()) {
            Set beans = Arc.container().beanManager().getBeans(ReactiveMongoClient.class, new Annotation[0]);
            for (Bean bean : beans) {
                if (bean.getName() == null) continue;
                return (ReactiveMongoClient)Arc.container().instance(entity.clientName()).get();
            }
        }
        return (ReactiveMongoClient)Arc.container().instance(ReactiveMongoClient.class, new Annotation[0]).get();
    }

    public static Uni<Object> findById(Class<?> entityClass, Object id) {
        Uni<Optional> optionalEntity = ReactiveMongoOperations.findByIdOptional(entityClass, id);
        return optionalEntity.onItem().apply(optional -> optional.orElse(null));
    }

    public static Uni<Optional> findByIdOptional(Class<?> entityClass, Object id) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.find((Bson)new Document(ID, id)).collectItems().first().onItem().apply(Optional::ofNullable);
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, String query, Object ... params) {
        return ReactiveMongoOperations.find(entityClass, query, null, params);
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Document docSort = ReactiveMongoOperations.sortToDocument(sort);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return new ReactivePanacheQueryImpl(collection, docQuery, docSort);
    }

    static String bindFilter(Class<?> clazz, String query, Object[] params) {
        String bindQuery = ReactiveMongoOperations.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    static String bindFilter(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = ReactiveMongoOperations.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    static String bindUpdate(Class<?> clazz, String query, Object[] params) {
        String bindUpdate = ReactiveMongoOperations.bindQuery(clazz, query, params);
        if (!bindUpdate.contains("$set")) {
            bindUpdate = "{'$set':" + bindUpdate + "}";
        }
        LOGGER.debug((Object)bindUpdate);
        return bindUpdate;
    }

    static String bindUpdate(Class<?> clazz, String query, Map<String, Object> params) {
        String bindUpdate = ReactiveMongoOperations.bindQuery(clazz, query, params);
        if (!bindUpdate.contains("$set")) {
            bindUpdate = "{'$set':" + bindUpdate + "}";
        }
        LOGGER.debug((Object)bindUpdate);
        return bindUpdate;
    }

    static String bindQuery(Class<?> clazz, String query, Object[] params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    static String bindQuery(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, String query, Map<String, Object> params) {
        return ReactiveMongoOperations.find(entityClass, query, null, params);
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Document docSort = ReactiveMongoOperations.sortToDocument(sort);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return new ReactivePanacheQueryImpl(collection, docQuery, docSort);
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, String query, Parameters params) {
        return ReactiveMongoOperations.find(entityClass, query, null, params.map());
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params.map());
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, Document query, Sort sort) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        Document sortDoc = ReactiveMongoOperations.sortToDocument(sort);
        return new ReactivePanacheQueryImpl(collection, query, sortDoc);
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, Document query, Document sort) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return new ReactivePanacheQueryImpl(collection, query, sort);
    }

    public static ReactivePanacheQuery<?> find(Class<?> entityClass, Document query) {
        return ReactiveMongoOperations.find(entityClass, query, (Document)null);
    }

    public static Uni<List<?>> list(Class<?> entityClass, String query, Object ... params) {
        return ReactiveMongoOperations.find(entityClass, query, params).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return ReactiveMongoOperations.find(entityClass, query, params).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, String query, Parameters params) {
        return ReactiveMongoOperations.find(entityClass, query, params).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, Document query) {
        return ReactiveMongoOperations.find(entityClass, query).list();
    }

    public static Uni<List<?>> list(Class<?> entityClass, Document query, Document sort) {
        return ReactiveMongoOperations.find(entityClass, query, sort).list();
    }

    public static Multi<?> stream(Class<?> entityClass, String query, Object ... params) {
        return ReactiveMongoOperations.find(entityClass, query, params).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return ReactiveMongoOperations.find(entityClass, query, params).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, String query, Parameters params) {
        return ReactiveMongoOperations.find(entityClass, query, params).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return ReactiveMongoOperations.find(entityClass, query, sort, params).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, Document query) {
        return ReactiveMongoOperations.find(entityClass, query).stream();
    }

    public static Multi<?> stream(Class<?> entityClass, Document query, Document sort) {
        return ReactiveMongoOperations.find(entityClass, query, sort).stream();
    }

    public static ReactivePanacheQuery<?> findAll(Class<?> entityClass) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return new ReactivePanacheQueryImpl(collection, null, null);
    }

    public static ReactivePanacheQuery<?> findAll(Class<?> entityClass, Sort sort) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        Document sortDoc = ReactiveMongoOperations.sortToDocument(sort);
        return new ReactivePanacheQueryImpl(collection, null, sortDoc);
    }

    private static Document sortToDocument(Sort sort) {
        if (sort == null) {
            return null;
        }
        Document sortDoc = new Document();
        for (Sort.Column col : sort.getColumns()) {
            sortDoc.append(col.getName(), (Object)(col.getDirection() == Sort.Direction.Ascending ? 1 : -1));
        }
        return sortDoc;
    }

    public static Uni<List<?>> listAll(Class<?> entityClass) {
        return ReactiveMongoOperations.findAll(entityClass).list();
    }

    public static Uni<List<?>> listAll(Class<?> entityClass, Sort sort) {
        return ReactiveMongoOperations.findAll(entityClass, sort).list();
    }

    public static Multi<?> streamAll(Class<?> entityClass) {
        return ReactiveMongoOperations.findAll(entityClass).stream();
    }

    public static Multi<?> streamAll(Class<?> entityClass, Sort sort) {
        return ReactiveMongoOperations.findAll(entityClass, sort).stream();
    }

    public static Uni<Long> count(Class<?> entityClass) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.countDocuments();
    }

    public static Uni<Long> count(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.countDocuments((Bson)docQuery);
    }

    public static Uni<Long> count(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.countDocuments((Bson)docQuery);
    }

    public static Uni<Long> count(Class<?> entityClass, String query, Parameters params) {
        return ReactiveMongoOperations.count(entityClass, query, params.map());
    }

    public static Uni<Long> count(Class<?> entityClass, Document query) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.countDocuments((Bson)query);
    }

    public static Uni<Long> deleteAll(Class<?> entityClass) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)new Document()).map(deleteResult -> deleteResult.getDeletedCount());
    }

    public static Uni<Boolean> deleteById(Class<?> entityClass, Object id) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        Document query = new Document().append(ID, id);
        return collection.deleteOne((Bson)query).map(results -> results.getDeletedCount() == 1L);
    }

    public static Uni<Long> delete(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)docQuery).map(deleteResult -> deleteResult.getDeletedCount());
    }

    public static Uni<Long> delete(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)docQuery).map(deleteResult -> deleteResult.getDeletedCount());
    }

    public static Uni<Long> delete(Class<?> entityClass, String query, Parameters params) {
        return ReactiveMongoOperations.delete(entityClass, query, params.map());
    }

    public static Uni<Long> delete(Class<?> entityClass, Document query) {
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)query).map(deleteResult -> deleteResult.getDeletedCount());
    }

    public static ReactivePanacheUpdate update(Class<?> entityClass, String update, Map<String, Object> params) {
        return ReactiveMongoOperations.executeUpdate(entityClass, update, params);
    }

    public static ReactivePanacheUpdate update(Class<?> entityClass, String update, Parameters params) {
        return ReactiveMongoOperations.update(entityClass, update, params.map());
    }

    public static ReactivePanacheUpdate update(Class<?> entityClass, String update, Object ... params) {
        return ReactiveMongoOperations.executeUpdate(entityClass, update, params);
    }

    private static ReactivePanacheUpdate executeUpdate(Class<?> entityClass, String update, Object ... params) {
        String bindUpdate = ReactiveMongoOperations.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return new ReactivePanacheUpdateImpl(entityClass, docUpdate, collection);
    }

    private static ReactivePanacheUpdate executeUpdate(Class<?> entityClass, String update, Map<String, Object> params) {
        String bindUpdate = ReactiveMongoOperations.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        ReactiveMongoCollection collection = ReactiveMongoOperations.mongoCollection(entityClass);
        return new ReactivePanacheUpdateImpl(entityClass, docUpdate, collection);
    }

    public static IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses");
    }
}

