/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.reactive.runtime;

import io.quarkus.mongodb.panache.reactive.ReactivePanacheUpdate;
import io.quarkus.mongodb.panache.reactive.runtime.ReactiveMongoOperations;
import io.quarkus.mongodb.reactive.ReactiveMongoCollection;
import io.quarkus.panache.common.Parameters;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ReactivePanacheUpdateImpl
implements ReactivePanacheUpdate {
    private Class<?> entityClass;
    private Document update;
    private ReactiveMongoCollection<?> collection;

    public ReactivePanacheUpdateImpl(Class<?> entityClass, Document update, ReactiveMongoCollection<?> collection) {
        this.entityClass = entityClass;
        this.update = update;
        this.collection = collection;
    }

    @Override
    public Uni<Long> where(String query, Object ... params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(this.entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        return this.collection.updateMany((Bson)docQuery, (Bson)this.update).map(result -> result.getModifiedCount());
    }

    @Override
    public Uni<Long> where(String query, Map<String, Object> params) {
        String bindQuery = ReactiveMongoOperations.bindFilter(this.entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        return this.collection.updateMany((Bson)docQuery, (Bson)this.update).map(result -> result.getModifiedCount());
    }

    @Override
    public Uni<Long> where(String query, Parameters params) {
        return this.where(query, params.map());
    }

    @Override
    public Uni<Long> all() {
        return this.collection.updateMany((Bson)new Document(), (Bson)this.update).map(result -> result.getModifiedCount());
    }
}

