/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.panache.runtime.MongoPropertyUtil;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PanacheQueryImpl<Entity>
implements PanacheQuery<Entity> {
    private MongoCollection collection;
    private Document mongoQuery;
    private Document sort;
    private Document projections;
    private Page page;
    private Long count;
    private Range range;

    PanacheQueryImpl(MongoCollection<? extends Entity> collection, Document mongoQuery, Document sort) {
        this.collection = collection;
        this.mongoQuery = mongoQuery;
        this.sort = sort;
    }

    @Override
    public <T> PanacheQuery<T> project(Class<T> type) {
        Set<String> fieldNames = MongoPropertyUtil.collectFields(type);
        this.projections = new Document();
        for (String fieldName : fieldNames) {
            this.projections.append(fieldName, (Object)1);
        }
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(Page page) {
        this.page = page;
        this.range = null;
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(int pageIndex, int pageSize) {
        return this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    @Override
    public <T extends Entity> PanacheQuery<T> nextPage() {
        this.checkPagination();
        return this.page(this.page.next());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> previousPage() {
        this.checkPagination();
        return this.page(this.page.previous());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> firstPage() {
        this.checkPagination();
        return this.page(this.page.first());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> lastPage() {
        this.checkPagination();
        return this.page(this.page.index(this.pageCount() - 1));
    }

    @Override
    public boolean hasNextPage() {
        this.checkPagination();
        return this.page.index < this.pageCount() - 1;
    }

    @Override
    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    @Override
    public int pageCount() {
        this.checkPagination();
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    @Override
    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    @Override
    public <T extends Entity> PanacheQuery<T> range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
        return this;
    }

    @Override
    public long count() {
        if (this.count == null) {
            this.count = this.collection.countDocuments((Bson)this.mongoQuery);
        }
        return this.count;
    }

    @Override
    public <T extends Entity> List<T> list() {
        return this.list(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Entity> List<T> list(Integer limit) {
        FindIterable find;
        ArrayList<Object> list = new ArrayList<Object>();
        FindIterable findIterable = find = this.mongoQuery == null ? this.collection.find() : this.collection.find((Bson)this.mongoQuery);
        if (this.projections != null) {
            find.projection((Bson)this.projections);
        }
        this.manageOffsets(find, limit);
        try (MongoCursor cursor = find.sort((Bson)this.sort).iterator();){
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                list.add(entity);
            }
        }
        return list;
    }

    @Override
    public <T extends Entity> Stream<T> stream() {
        return this.list().stream();
    }

    @Override
    public <T extends Entity> T firstResult() {
        List<T> list = this.list(1);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T extends Entity> Optional<T> firstResultOptional() {
        return Optional.ofNullable(this.firstResult());
    }

    @Override
    public <T extends Entity> T singleResult() {
        List<T> list = this.list(2);
        if (list.size() != 1) {
            throw new PanacheQueryException("There should be only one result");
        }
        return list.get(0);
    }

    @Override
    public <T extends Entity> Optional<T> singleResultOptional() {
        List<T> list = this.list(2);
        if (list.size() > 1) {
            throw new PanacheQueryException("There should be no more than one result");
        }
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
    }

    private void manageOffsets(FindIterable find, Integer limit) {
        if (this.range != null) {
            find.skip(this.range.getStartIndex());
            if (limit == null) {
                find.limit(this.range.getLastIndex() - this.range.getStartIndex() + 1);
            }
        } else if (this.page != null) {
            find.skip(this.page.index * this.page.size);
            if (limit == null) {
                find.limit(this.page.size);
            }
        }
        if (limit != null) {
            find.limit(limit.intValue());
        }
    }
}

