/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.MongoCollection;
import io.quarkus.mongodb.panache.PanacheUpdate;
import io.quarkus.mongodb.panache.runtime.MongoOperations;
import io.quarkus.panache.common.Parameters;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PanacheUpdateImpl
implements PanacheUpdate {
    private Class<?> entityClass;
    private Document update;
    private MongoCollection collection;

    public PanacheUpdateImpl(Class<?> entityClass, Document update, MongoCollection collection) {
        this.entityClass = entityClass;
        this.update = update;
        this.collection = collection;
    }

    @Override
    public long where(String query, Object ... params) {
        String bindQuery = MongoOperations.bindFilter(this.entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        return this.collection.updateMany((Bson)docQuery, (Bson)this.update).getModifiedCount();
    }

    @Override
    public long where(String query, Map<String, Object> params) {
        String bindQuery = MongoOperations.bindFilter(this.entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        return this.collection.updateMany((Bson)docQuery, (Bson)this.update).getModifiedCount();
    }

    @Override
    public long where(String query, Parameters params) {
        return this.where(query, params.map());
    }

    @Override
    public long all() {
        return this.collection.updateMany((Bson)new Document(), (Bson)this.update).getModifiedCount();
    }
}

