/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.reactive.runtime;

import com.mongodb.client.model.Collation;
import io.quarkus.mongodb.FindOptions;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheQuery;
import io.quarkus.mongodb.panache.runtime.MongoPropertyUtil;
import io.quarkus.mongodb.reactive.ReactiveMongoCollection;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ReactivePanacheQueryImpl<Entity>
implements ReactivePanacheQuery<Entity> {
    private ReactiveMongoCollection collection;
    private Bson mongoQuery;
    private Bson sort;
    private Bson projections;
    private Page page;
    private Uni<Long> count;
    private Range range;
    private Collation collation;

    ReactivePanacheQueryImpl(ReactiveMongoCollection<? extends Entity> collection, Bson mongoQuery, Bson sort) {
        this.collection = collection;
        this.mongoQuery = mongoQuery;
        this.sort = sort;
    }

    private ReactivePanacheQueryImpl(ReactivePanacheQueryImpl previousQuery, Bson projections, Class<?> type) {
        this.collection = previousQuery.collection.withDocumentClass(type);
        this.mongoQuery = previousQuery.mongoQuery;
        this.sort = previousQuery.sort;
        this.projections = projections;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.collation = previousQuery.collation;
    }

    @Override
    public <T> ReactivePanacheQuery<T> project(Class<T> type) {
        Set<String> fieldNames = MongoPropertyUtil.collectFields(type);
        Document projections = new Document();
        for (String fieldName : fieldNames) {
            projections.append(fieldName, (Object)1);
        }
        return new ReactivePanacheQueryImpl<Entity>(this, (Bson)projections, type);
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> page(Page page) {
        this.page = page;
        this.range = null;
        return this;
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> page(int pageIndex, int pageSize) {
        return this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> nextPage() {
        this.checkPagination();
        return this.page(this.page.next());
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> previousPage() {
        this.checkPagination();
        return this.page(this.page.previous());
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> firstPage() {
        this.checkPagination();
        return this.page(this.page.first());
    }

    @Override
    public <T extends Entity> Uni<ReactivePanacheQuery<T>> lastPage() {
        this.checkPagination();
        return this.pageCount().map(pageCount -> this.page(this.page.index(pageCount - 1)));
    }

    @Override
    public Uni<Boolean> hasNextPage() {
        this.checkPagination();
        return this.pageCount().map(pageCount -> this.page.index < pageCount - 1);
    }

    @Override
    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    @Override
    public Uni<Integer> pageCount() {
        this.checkPagination();
        return this.count().map(count -> {
            if (count == 0L) {
                return 1;
            }
            return (int)Math.ceil((double)count.longValue() / (double)this.page.size);
        });
    }

    @Override
    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
        return this;
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> withCollation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Uni<Long> count() {
        if (this.count == null) {
            this.count = this.collection.countDocuments(this.mongoQuery);
        }
        return this.count;
    }

    @Override
    public <T extends Entity> Uni<List<T>> list() {
        Multi<T> results = this.stream();
        return results.collectItems().asList();
    }

    @Override
    public <T extends Entity> Multi<T> stream() {
        FindOptions options = this.buildOptions();
        return this.mongoQuery == null ? this.collection.find(options) : this.collection.find(this.mongoQuery, options);
    }

    @Override
    public <T extends Entity> Uni<T> firstResult() {
        Uni<Optional<T>> optionalEntity = this.firstResultOptional();
        return optionalEntity.map(optional -> optional.orElse(null));
    }

    @Override
    public <T extends Entity> Uni<Optional<T>> firstResultOptional() {
        FindOptions options = this.buildOptions(1);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find(this.mongoQuery, options);
        return results.collectItems().first().map(o -> Optional.ofNullable(o));
    }

    @Override
    public <T extends Entity> Uni<T> singleResult() {
        FindOptions options = this.buildOptions(2);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find(this.mongoQuery, options);
        return results.collectItems().asList().map(list -> {
            if (list.size() != 1) {
                throw new PanacheQueryException("There should be only one result");
            }
            return list.get(0);
        });
    }

    @Override
    public <T extends Entity> Uni<Optional<T>> singleResultOptional() {
        FindOptions options = this.buildOptions(2);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find(this.mongoQuery, options);
        return results.collectItems().asList().map(list -> {
            if (list.size() == 2) {
                throw new PanacheQueryException("There should be no more than one result");
            }
            return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
        });
    }

    private FindOptions buildOptions() {
        FindOptions options = new FindOptions();
        options.sort(this.sort);
        if (this.range != null) {
            options.skip(this.range.getStartIndex()).limit(this.range.getLastIndex() - this.range.getStartIndex() + 1);
        } else if (this.page != null) {
            options.skip(this.page.index * this.page.size).limit(this.page.size);
        }
        if (this.projections != null) {
            options.projection(this.projections);
        }
        if (this.collation != null) {
            options.collation(this.collation);
        }
        return options;
    }

    private FindOptions buildOptions(int maxResults) {
        FindOptions options = new FindOptions();
        options.sort(this.sort);
        if (this.range != null) {
            options.skip(this.range.getStartIndex());
        } else if (this.page != null) {
            options.skip(this.page.index * this.page.size);
        }
        if (this.projections != null) {
            options.projection(this.projections);
        }
        if (this.collation != null) {
            options.collation(this.collation);
        }
        return options.limit(maxResults);
    }
}

