/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.DeleteResult;
import io.quarkus.mongodb.panache.MongoEntity;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.panache.PanacheUpdate;
import io.quarkus.mongodb.panache.binder.NativeQueryBinder;
import io.quarkus.mongodb.panache.binder.PanacheQlQueryBinder;
import io.quarkus.mongodb.panache.runtime.BeanUtils;
import io.quarkus.mongodb.panache.runtime.PanacheQueryImpl;
import io.quarkus.mongodb.panache.runtime.PanacheUpdateImpl;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.jboss.logging.Logger;

public class MongoOperations {
    private static final Logger LOGGER = Logger.getLogger(MongoOperations.class);
    public static final String ID = "_id";
    private static final Map<String, String> defaultDatabaseName = new ConcurrentHashMap<String, String>();

    public static void persist(Object entity) {
        MongoCollection collection = MongoOperations.mongoCollection(entity);
        MongoOperations.persist(collection, entity);
    }

    public static void persist(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
            MongoOperations.persist(collection, objects);
        }
    }

    public static void persist(Object firstEntity, Object ... entities) {
        MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            MongoOperations.persist(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            MongoOperations.persist(collection, entityList);
        }
    }

    public static void persist(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
            MongoOperations.persist(collection, objects);
        }
    }

    public static void update(Object entity) {
        MongoCollection collection = MongoOperations.mongoCollection(entity);
        MongoOperations.update(collection, entity);
    }

    public static void update(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
            MongoOperations.update(collection, objects);
        }
    }

    public static void update(Object firstEntity, Object ... entities) {
        MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            MongoOperations.update(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            MongoOperations.update(collection, entityList);
        }
    }

    public static void update(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
            MongoOperations.update(collection, objects);
        }
    }

    public static void persistOrUpdate(Object entity) {
        MongoCollection collection = MongoOperations.mongoCollection(entity);
        MongoOperations.persistOrUpdate(collection, entity);
    }

    public static void persistOrUpdate(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
            MongoOperations.persistOrUpdate(collection, objects);
        }
    }

    public static void persistOrUpdate(Object firstEntity, Object ... entities) {
        MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            MongoOperations.persistOrUpdate(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            MongoOperations.persistOrUpdate(collection, entityList);
        }
    }

    public static void persistOrUpdate(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = MongoOperations.mongoCollection(firstEntity);
            MongoOperations.persistOrUpdate(collection, objects);
        }
    }

    public static void delete(Object entity) {
        MongoCollection collection = MongoOperations.mongoCollection(entity);
        BsonDocument document = MongoOperations.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        BsonDocument query = new BsonDocument().append(ID, id);
        collection.deleteOne((Bson)query);
    }

    public static MongoCollection mongoCollection(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        MongoDatabase database = MongoOperations.mongoDatabase(mongoEntity);
        if (mongoEntity != null && !mongoEntity.collection().isEmpty()) {
            return database.getCollection(mongoEntity.collection(), entityClass);
        }
        return database.getCollection(entityClass.getSimpleName(), entityClass);
    }

    public static MongoDatabase mongoDatabase(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        return MongoOperations.mongoDatabase(mongoEntity);
    }

    private static void persist(MongoCollection collection, Object entity) {
        collection.insertOne(entity);
    }

    private static void persist(MongoCollection collection, List<Object> entities) {
        collection.insertMany(entities);
    }

    private static void update(MongoCollection collection, Object entity) {
        BsonDocument document = MongoOperations.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        BsonDocument query = new BsonDocument().append(ID, id);
        collection.replaceOne((Bson)query, entity);
    }

    private static void update(MongoCollection collection, List<Object> entities) {
        for (Object entity : entities) {
            MongoOperations.update(collection, entity);
        }
    }

    private static void persistOrUpdate(MongoCollection collection, Object entity) {
        BsonDocument document = MongoOperations.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        if (id == null) {
            collection.insertOne(entity);
        } else {
            BsonDocument query = new BsonDocument().append(ID, id);
            collection.replaceOne((Bson)query, entity, new ReplaceOptions().upsert(true));
        }
    }

    private static void persistOrUpdate(MongoCollection collection, List<Object> entities) {
        ArrayList<Object> bulk = new ArrayList<Object>();
        for (Object entity : entities) {
            BsonDocument document = MongoOperations.getBsonDocument(collection, entity);
            BsonValue id = document.get((Object)ID);
            if (id == null) {
                bulk.add(new InsertOneModel(entity));
                continue;
            }
            BsonDocument query = new BsonDocument().append(ID, id);
            bulk.add(new ReplaceOneModel((Bson)query, entity, new ReplaceOptions().upsert(true)));
        }
        collection.bulkWrite(bulk);
    }

    private static BsonDocument getBsonDocument(MongoCollection collection, Object entity) {
        BsonDocument document = new BsonDocument();
        Codec codec = collection.getCodecRegistry().get(entity.getClass());
        codec.encode((BsonWriter)new BsonDocumentWriter(document), entity, EncoderContext.builder().build());
        return document;
    }

    private static MongoCollection mongoCollection(Object entity) {
        Class<?> entityClass = entity.getClass();
        return MongoOperations.mongoCollection(entityClass);
    }

    private static MongoDatabase mongoDatabase(MongoEntity entity) {
        MongoClient mongoClient = BeanUtils.clientFromArc(entity, MongoClient.class);
        if (entity != null && !entity.database().isEmpty()) {
            return mongoClient.getDatabase(entity.database());
        }
        String databaseName = MongoOperations.getDefaultDatabaseName(entity);
        return mongoClient.getDatabase(databaseName);
    }

    private static String getDefaultDatabaseName(final MongoEntity entity) {
        return defaultDatabaseName.computeIfAbsent(BeanUtils.beanName(entity), new Function<String, String>(){

            @Override
            public String apply(String beanName) {
                return BeanUtils.getDatabaseName(entity, beanName);
            }
        });
    }

    public static Object findById(Class<?> entityClass, Object id) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.find((Bson)new Document(ID, id)).first();
    }

    public static Optional findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(MongoOperations.findById(entityClass, id));
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Object ... params) {
        return MongoOperations.find(entityClass, query, null, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String bindQuery = MongoOperations.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        Document docSort = MongoOperations.sortToDocument(sort);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return new PanacheQueryImpl(collection, (Bson)docQuery, (Bson)docSort);
    }

    static String bindFilter(Class<?> clazz, String query, Object[] params) {
        String bindQuery = MongoOperations.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    static String bindFilter(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = MongoOperations.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    static String bindUpdate(Class<?> clazz, String query, Object[] params) {
        String bindUpdate = MongoOperations.bindQuery(clazz, query, params);
        if (!bindUpdate.contains("$set")) {
            bindUpdate = "{'$set':" + bindUpdate + "}";
        }
        LOGGER.debug((Object)bindUpdate);
        return bindUpdate;
    }

    static String bindUpdate(Class<?> clazz, String query, Map<String, Object> params) {
        String bindUpdate = MongoOperations.bindQuery(clazz, query, params);
        if (!bindUpdate.contains("$set")) {
            bindUpdate = "{'$set':" + bindUpdate + "}";
        }
        LOGGER.debug((Object)bindUpdate);
        return bindUpdate;
    }

    private static String bindQuery(Class<?> clazz, String query, Object[] params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    private static String bindQuery(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Map<String, Object> params) {
        return MongoOperations.find(entityClass, query, null, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String bindQuery = MongoOperations.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        Document docSort = MongoOperations.sortToDocument(sort);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return new PanacheQueryImpl(collection, (Bson)docQuery, (Bson)docSort);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Parameters params) {
        return MongoOperations.find(entityClass, query, null, params.map());
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return MongoOperations.find(entityClass, query, sort, params.map());
    }

    public static PanacheQuery<?> find(Class<?> entityClass, Document query, Sort sort) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        Document sortDoc = MongoOperations.sortToDocument(sort);
        return new PanacheQueryImpl(collection, (Bson)query, (Bson)sortDoc);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, Document query, Document sort) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return new PanacheQueryImpl(collection, (Bson)query, (Bson)sort);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, Document query) {
        return MongoOperations.find(entityClass, query, (Document)null);
    }

    public static List<?> list(Class<?> entityClass, String query, Object ... params) {
        return MongoOperations.find(entityClass, query, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return MongoOperations.find(entityClass, query, sort, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return MongoOperations.find(entityClass, query, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return MongoOperations.find(entityClass, query, sort, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Parameters params) {
        return MongoOperations.find(entityClass, query, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return MongoOperations.find(entityClass, query, sort, params).list();
    }

    public static List<?> list(Class<?> entityClass, Document query) {
        return MongoOperations.find(entityClass, query).list();
    }

    public static List<?> list(Class<?> entityClass, Document query, Document sort) {
        return MongoOperations.find(entityClass, query, sort).list();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Object ... params) {
        return MongoOperations.find(entityClass, query, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return MongoOperations.find(entityClass, query, sort, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return MongoOperations.find(entityClass, query, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return MongoOperations.find(entityClass, query, sort, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Parameters params) {
        return MongoOperations.find(entityClass, query, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return MongoOperations.find(entityClass, query, sort, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, Document query) {
        return MongoOperations.find(entityClass, query).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, Document query, Document sort) {
        return MongoOperations.find(entityClass, query, sort).stream();
    }

    public static PanacheQuery<?> findAll(Class<?> entityClass) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return new PanacheQueryImpl(collection, null, null);
    }

    public static PanacheQuery<?> findAll(Class<?> entityClass, Sort sort) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        Document sortDoc = MongoOperations.sortToDocument(sort);
        return new PanacheQueryImpl(collection, null, (Bson)sortDoc);
    }

    private static Document sortToDocument(Sort sort) {
        if (sort == null) {
            return null;
        }
        Document sortDoc = new Document();
        for (Sort.Column col : sort.getColumns()) {
            sortDoc.append(col.getName(), (Object)(col.getDirection() == Sort.Direction.Ascending ? 1 : -1));
        }
        return sortDoc;
    }

    public static List<?> listAll(Class<?> entityClass) {
        return MongoOperations.findAll(entityClass).list();
    }

    public static List<?> listAll(Class<?> entityClass, Sort sort) {
        return MongoOperations.findAll(entityClass, sort).list();
    }

    public static Stream<?> streamAll(Class<?> entityClass) {
        return MongoOperations.findAll(entityClass).stream();
    }

    public static Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return MongoOperations.findAll(entityClass, sort).stream();
    }

    public static long count(Class<?> entityClass) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.countDocuments();
    }

    public static long count(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = MongoOperations.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.countDocuments((Bson)docQuery);
    }

    public static long count(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = MongoOperations.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.countDocuments((Bson)docQuery);
    }

    public static long count(Class<?> entityClass, String query, Parameters params) {
        return MongoOperations.count(entityClass, query, params.map());
    }

    public static long count(Class<?> entityClass, Document query) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.countDocuments((Bson)query);
    }

    public static long deleteAll(Class<?> entityClass) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)new Document()).getDeletedCount();
    }

    public static boolean deleteById(Class<?> entityClass, Object id) {
        Document query;
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        DeleteResult results = collection.deleteOne((Bson)(query = new Document().append(ID, id)));
        return results.getDeletedCount() == 1L;
    }

    public static long delete(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = MongoOperations.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)docQuery).getDeletedCount();
    }

    public static long delete(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = MongoOperations.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)docQuery).getDeletedCount();
    }

    public static long delete(Class<?> entityClass, String query, Parameters params) {
        return MongoOperations.delete(entityClass, query, params.map());
    }

    public static long delete(Class<?> entityClass, Document query) {
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return collection.deleteMany((Bson)query).getDeletedCount();
    }

    public static PanacheUpdate update(Class<?> entityClass, String update, Map<String, Object> params) {
        return MongoOperations.executeUpdate(entityClass, update, params);
    }

    public static PanacheUpdate update(Class<?> entityClass, String update, Parameters params) {
        return MongoOperations.update(entityClass, update, params.map());
    }

    public static PanacheUpdate update(Class<?> entityClass, String update, Object ... params) {
        return MongoOperations.executeUpdate(entityClass, update, params);
    }

    private static PanacheUpdate executeUpdate(Class<?> entityClass, String update, Object ... params) {
        String bindUpdate = MongoOperations.bindUpdate(entityClass, update, params);
        BsonDocument docUpdate = BsonDocument.parse((String)bindUpdate);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return new PanacheUpdateImpl(entityClass, (Bson)docUpdate, collection);
    }

    private static PanacheUpdate executeUpdate(Class<?> entityClass, String update, Map<String, Object> params) {
        String bindUpdate = MongoOperations.bindUpdate(entityClass, update, params);
        BsonDocument docUpdate = BsonDocument.parse((String)bindUpdate);
        MongoCollection collection = MongoOperations.mongoCollection(entityClass);
        return new PanacheUpdateImpl(entityClass, (Bson)docUpdate, collection);
    }

    public static IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses");
    }
}

