/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ContextHandlerBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.mutiny.runtime.MutinyInfrastructure;
import io.quarkus.runtime.ShutdownContext;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.threads.ContextHandler;

public class MutinyProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(ExecutorBuildItem executorBuildItem, MutinyInfrastructure recorder, ShutdownContextBuildItem shutdownContext, Optional<ContextHandlerBuildItem> contextHandler) {
        ScheduledExecutorService executor = executorBuildItem.getExecutorProxy();
        ContextHandler handler = contextHandler.map(ContextHandlerBuildItem::contextHandler).orElse(null);
        recorder.configureMutinyInfrastructure((ExecutorService)executor, (ShutdownContext)shutdownContext, handler);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void buildTimeInit(MutinyInfrastructure recorder) {
        recorder.configureDroppedExceptionHandler();
        recorder.configureThreadBlockingChecker();
        recorder.configureOperatorLogger();
    }
}

