/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import io.quarkus.narayana.jta.runtime.NarayanaJtaConfiguration;
import io.quarkus.narayana.jta.runtime.QuarkusPropertiesFactory;
import io.quarkus.runtime.annotations.Template;
import java.lang.reflect.Field;
import java.util.Properties;
import org.jboss.logging.Logger;

@Template
public class NarayanaJtaTemplate {
    private static Properties defaultProperties;
    private static final Logger log;

    public void setNodeName(NarayanaJtaConfiguration transactions) {
        try {
            arjPropertyManager.getCoreEnvironmentBean().setNodeIdentifier(transactions.nodeName);
            TxControl.setXANodeName((String)transactions.xaNodeName.orElse(transactions.nodeName));
        }
        catch (CoreEnvironmentBeanException e) {
            e.printStackTrace();
        }
    }

    public void setDefaultProperties(Properties properties) {
        try {
            Field field = PropertiesFactory.class.getDeclaredField("delegatePropertiesFactory");
            field.setAccessible(true);
            field.set(null, (Object)new QuarkusPropertiesFactory(properties));
        }
        catch (Exception e) {
            log.error((Object)"Could not override transaction properties factory", (Throwable)e);
        }
        defaultProperties = properties;
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    static {
        log = Logger.getLogger(NarayanaJtaTemplate.class);
    }
}

