/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.interceptor;

import com.arjuna.ats.jta.logging.jtaLogger;
import io.quarkus.arc.runtime.InterceptorBindings;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;

public abstract class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    TransactionManager transactionManager;
    private final boolean userTransactionAvailable;

    protected TransactionalInterceptorBase(boolean userTransactionAvailable) {
        this.userTransactionAvailable = userTransactionAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InvocationContext ic) throws Exception {
        TransactionManager tm = this.transactionManager;
        Transaction tx = tm.getTransaction();
        boolean previousUserTransactionAvailability = this.setUserTransactionAvailable(this.userTransactionAvailable);
        try {
            Object object = this.doIntercept(tm, tx, ic);
            return object;
        }
        finally {
            this.resetUserTransactionAvailability(previousUserTransactionAvailability);
        }
    }

    protected abstract Object doIntercept(TransactionManager var1, Transaction var2, InvocationContext var3) throws Exception;

    private Transactional getTransactional(InvocationContext ic) {
        Set bindings = InterceptorBindings.getInterceptorBindings((InvocationContext)ic);
        for (Annotation i : bindings) {
            if (i.annotationType() != Transactional.class) continue;
            return (Transactional)i;
        }
        throw new RuntimeException(jtaLogger.i18NLogger.get_expected_transactional_annotation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm) throws Exception {
        tm.begin();
        Transaction tx = tm.getTransaction();
        try {
            Object object = ic.proceed();
            return object;
        }
        catch (Exception e) {
            this.handleException(ic, e, tx);
        }
        finally {
            this.endTransaction(tm, tx);
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object invokeInCallerTx(InvocationContext ic, Transaction tx) throws Exception {
        try {
            return ic.proceed();
        }
        catch (Exception e) {
            this.handleException(ic, e, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    protected void handleException(InvocationContext ic, Exception e, Transaction tx) throws Exception {
        Transactional transactional = this.getTransactional(ic);
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(e.getClass())) continue;
            throw e;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(e.getClass())) continue;
            tx.setRollbackOnly();
            throw e;
        }
        if (e instanceof RuntimeException) {
            tx.setRollbackOnly();
            throw e;
        }
        throw e;
    }

    protected void endTransaction(TransactionManager tm, Transaction tx) throws Exception {
        if (tx != tm.getTransaction()) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
        }
        if (tx.getStatus() == 1) {
            tm.rollback();
        } else {
            tm.commit();
        }
    }

    protected boolean setUserTransactionAvailable(boolean available) {
        boolean previousUserTransactionAvailability = ServerVMClientUserTransaction.isAvailable();
        ServerVMClientUserTransaction.setAvailability((boolean)available);
        return previousUserTransactionAvailability;
    }

    protected void resetUserTransactionAvailability(boolean previousUserTransactionAvailability) {
        ServerVMClientUserTransaction.setAvailability((boolean)previousUserTransactionAvailability);
    }
}

