/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import io.quarkus.narayana.jta.runtime.QuarkusPropertiesFactory;
import io.quarkus.narayana.jta.runtime.TransactionManagerConfiguration;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.Field;
import java.util.Properties;
import org.jboss.logging.Logger;

@Recorder
public class NarayanaJtaRecorder {
    private static Properties defaultProperties;
    private static final Logger log;

    public void setNodeName(TransactionManagerConfiguration transactions) {
        try {
            arjPropertyManager.getCoreEnvironmentBean().setNodeIdentifier(transactions.nodeName);
            TxControl.setXANodeName((String)transactions.xaNodeName.orElse(transactions.nodeName));
        }
        catch (CoreEnvironmentBeanException e) {
            e.printStackTrace();
        }
    }

    public void setDefaultProperties(Properties properties) {
        try {
            Field field = PropertiesFactory.class.getDeclaredField("delegatePropertiesFactory");
            field.setAccessible(true);
            field.set(null, (Object)new QuarkusPropertiesFactory(properties));
        }
        catch (Exception e) {
            log.error((Object)"Could not override transaction properties factory", (Throwable)e);
        }
        defaultProperties = properties;
    }

    public void setDefaultTimeout(TransactionManagerConfiguration transactions) {
        transactions.defaultTransactionTimeout.ifPresent(defaultTimeout -> TxControl.setDefaultTimeout((int)((int)defaultTimeout.getSeconds())));
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    static {
        log = Logger.getLogger(NarayanaJtaRecorder.class);
    }
}

