/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.jta.TransactionManager;
import java.io.Serializable;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionScoped;

@Singleton
public class CDIDelegatingTransactionManager
implements javax.transaction.TransactionManager,
Serializable {
    private static final long serialVersionUID = 1598L;
    private final transient TransactionManagerImple delegate = (TransactionManagerImple)TransactionManager.transactionManager();
    @Inject
    @Initialized(value=TransactionScoped.class)
    private Event<Transaction> transactionScopeInitialized;
    @Inject
    @BeforeDestroyed(value=TransactionScoped.class)
    private Event<Object> transactionScopeBeforeDestroyed;
    @Inject
    @Destroyed(value=TransactionScoped.class)
    private Event<Object> transactionScopeDestroyed;

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        if (this.transactionScopeInitialized != null) {
            this.transactionScopeInitialized.fire((Object)this.getTransaction());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.transactionScopeBeforeDestroyed != null) {
            this.transactionScopeBeforeDestroyed.fire((Object)this.getTransaction());
        }
        try {
            this.delegate.commit();
        }
        finally {
            if (this.transactionScopeDestroyed != null) {
                this.transactionScopeDestroyed.fire((Object)this.toString());
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.transactionScopeBeforeDestroyed != null) {
            this.transactionScopeBeforeDestroyed.fire((Object)this.getTransaction());
        }
        try {
            this.delegate.rollback();
        }
        finally {
            if (this.transactionScopeDestroyed != null) {
                this.transactionScopeDestroyed.fire((Object)this.toString());
            }
        }
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.delegate.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.delegate.resume(transaction);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.delegate.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws SystemException {
        return this.delegate.getTimeout();
    }

    public Transaction suspend() throws SystemException {
        return this.delegate.suspend();
    }
}

