/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import io.quarkus.arc.Unremovable;
import java.io.Serializable;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionScoped;
import org.jboss.logging.Logger;

@Singleton
@Unremovable
public class CDIDelegatingTransactionManager
implements TransactionManager,
Serializable {
    private static final Logger log = Logger.getLogger(CDIDelegatingTransactionManager.class);
    private static final long serialVersionUID = 1598L;
    private final transient TransactionManagerImple delegate = (TransactionManagerImple)com.arjuna.ats.jta.TransactionManager.transactionManager();
    @Inject
    @Initialized(value=TransactionScoped.class)
    Event<Transaction> transactionScopeInitialized;
    @Inject
    @BeforeDestroyed(value=TransactionScoped.class)
    Event<Object> transactionScopeBeforeDestroyed;
    @Inject
    @Destroyed(value=TransactionScoped.class)
    Event<Object> transactionScopeDestroyed;

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        if (this.transactionScopeInitialized != null) {
            this.transactionScopeInitialized.fire((Object)this.getTransaction());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.transactionScopeBeforeDestroyed != null) {
            this.transactionScopeBeforeDestroyed.fire((Object)this.getTransaction());
        }
        try {
            this.delegate.commit();
        }
        finally {
            if (this.transactionScopeDestroyed != null) {
                this.transactionScopeDestroyed.fire((Object)this.toString());
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            if (this.transactionScopeBeforeDestroyed != null) {
                this.transactionScopeBeforeDestroyed.fire((Object)this.getTransaction());
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to fire @BeforeDestroyed(TransactionScoped.class)", t);
        }
        try {
            this.delegate.rollback();
        }
        finally {
            if (this.transactionScopeDestroyed != null) {
                this.transactionScopeDestroyed.fire((Object)this.toString());
            }
        }
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.delegate.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.delegate.resume(transaction);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.delegate.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws SystemException {
        return this.delegate.getTimeout();
    }

    public Transaction suspend() throws SystemException {
        return this.delegate.suspend();
    }
}

