/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import io.quarkus.arc.Arc;
import io.quarkus.narayana.jta.QuarkusTransactionException;
import io.quarkus.narayana.jta.RunOptionsBase;
import io.quarkus.narayana.jta.TransactionExceptionResult;
import io.quarkus.narayana.jta.runtime.TransactionManagerConfiguration;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;

class QuarkusTransactionImpl {
    private static final Logger log = Logger.getLogger(QuarkusTransactionImpl.class);
    private static jakarta.transaction.TransactionManager cachedTransactionManager;
    private static jakarta.transaction.UserTransaction cachedUserTransaction;

    QuarkusTransactionImpl() {
    }

    public static <T> T call(RunOptionsBase options, Callable<T> task) {
        switch (options.semantics) {
            case REQUIRE_NEW: {
                return QuarkusTransactionImpl.callRequireNew(options, task);
            }
            case DISALLOW_EXISTING: {
                return QuarkusTransactionImpl.callDisallowExisting(options, task);
            }
            case JOIN_EXISTING: {
                return QuarkusTransactionImpl.callJoinExisting(options, task);
            }
            case SUSPEND_EXISTING: {
                return QuarkusTransactionImpl.callSuspendExisting(options, task);
            }
        }
        throw new IllegalArgumentException("Unknown semantics");
    }

    private static <T> T callSuspendExisting(RunOptionsBase options, Callable<T> task) {
        if (options.exceptionHandler != null) {
            throw new IllegalStateException("Cannot specify both an exception handler and SUSPEND_EXISTING");
        }
        jakarta.transaction.TransactionManager transactionManager = QuarkusTransactionImpl.getTransactionManager();
        Transaction transaction = null;
        try {
            if (QuarkusTransactionImpl.isTransactionActive()) {
                transaction = transactionManager.suspend();
            }
            T result = task.call();
            if (transaction != null) {
                try {
                    transactionManager.resume(transaction);
                    transaction = null;
                }
                catch (Exception e) {
                    throw new QuarkusTransactionException(e);
                }
            }
            return result;
        }
        catch (Exception e) {
            if (transaction != null) {
                try {
                    transactionManager.resume(transaction);
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            if (e instanceof QuarkusTransactionException) {
                throw (QuarkusTransactionException)e;
            }
            throw new QuarkusTransactionException(e);
        }
    }

    private static <T> T callJoinExisting(RunOptionsBase options, Callable<T> task) {
        if (QuarkusTransactionImpl.isTransactionActive()) {
            return QuarkusTransactionImpl.callInTheirTx(options, task);
        }
        return QuarkusTransactionImpl.callInOurTx(options, task);
    }

    private static boolean isTransactionActive() {
        try {
            int status = QuarkusTransactionImpl.getUserTransaction().getStatus();
            return status != 6;
        }
        catch (SystemException e) {
            throw new QuarkusTransactionException(e);
        }
    }

    private static <T> T callDisallowExisting(RunOptionsBase options, Callable<T> task) {
        if (QuarkusTransactionImpl.isTransactionActive()) {
            throw new QuarkusTransactionException(new IllegalStateException("Transaction already active"));
        }
        return QuarkusTransactionImpl.callInOurTx(options, task);
    }

    private static <T> T callRequireNew(RunOptionsBase options, Callable<T> task) {
        jakarta.transaction.TransactionManager transactionManager = QuarkusTransactionImpl.getTransactionManager();
        Transaction transaction = null;
        try {
            if (QuarkusTransactionImpl.isTransactionActive()) {
                transaction = transactionManager.suspend();
            }
            T result = QuarkusTransactionImpl.callInOurTx(options, task);
            if (transaction != null) {
                try {
                    transactionManager.resume(transaction);
                    transaction = null;
                }
                catch (Exception e) {
                    throw new QuarkusTransactionException(e);
                }
            }
            return result;
        }
        catch (Exception e) {
            if (transaction != null) {
                try {
                    transactionManager.resume(transaction);
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new QuarkusTransactionException(e);
        }
    }

    private static <T> T callInOurTx(RunOptionsBase options, Callable<T> task) {
        QuarkusTransactionImpl.begin(options);
        try {
            T ret;
            try {
                ret = task.call();
            }
            catch (Throwable t) {
                TransactionExceptionResult handling = TransactionExceptionResult.ROLLBACK;
                if (options.exceptionHandler != null) {
                    handling = options.exceptionHandler.apply(t);
                }
                if (handling == TransactionExceptionResult.ROLLBACK) {
                    QuarkusTransactionImpl.getUserTransaction().rollback();
                } else {
                    QuarkusTransactionImpl.getUserTransaction().commit();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new QuarkusTransactionException(t);
            }
            try {
                QuarkusTransactionImpl.getUserTransaction().commit();
            }
            catch (Throwable t) {
                throw new QuarkusTransactionException(t);
            }
            return ret;
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException t) {
            try {
                QuarkusTransactionImpl.getUserTransaction().rollback();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
            throw new QuarkusTransactionException(t);
        }
    }

    private static <T> T callInTheirTx(RunOptionsBase options, Callable<T> task) {
        try {
            T ret;
            try {
                ret = task.call();
            }
            catch (Throwable t) {
                TransactionExceptionResult handling = TransactionExceptionResult.ROLLBACK;
                if (options.exceptionHandler != null) {
                    handling = options.exceptionHandler.apply(t);
                }
                if (handling == TransactionExceptionResult.ROLLBACK) {
                    QuarkusTransactionImpl.getUserTransaction().setRollbackOnly();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new QuarkusTransactionException(t);
            }
            return ret;
        }
        catch (SystemException t) {
            try {
                QuarkusTransactionImpl.getUserTransaction().rollback();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
            throw new QuarkusTransactionException(t);
        }
    }

    private static void begin(RunOptionsBase options) {
        int timeout = options != null ? options.timeout : 0;
        try {
            if (timeout > 0) {
                QuarkusTransactionImpl.getUserTransaction().setTransactionTimeout(timeout);
            }
            QuarkusTransactionImpl.getUserTransaction().begin();
        }
        catch (NotSupportedException | SystemException e) {
            throw new QuarkusTransactionException(e);
        }
        finally {
            if (timeout > 0) {
                try {
                    QuarkusTransactionImpl.getUserTransaction().setTransactionTimeout((int)((TransactionManagerConfiguration)Arc.container().instance(TransactionManagerConfiguration.class, (Annotation[])new Annotation[0]).get()).defaultTransactionTimeout.toSeconds());
                }
                catch (SystemException e) {
                    log.error((Object)"Failed to reset transaction timeout", (Throwable)e);
                }
            }
        }
    }

    static void rollback() {
        try {
            QuarkusTransactionImpl.getUserTransaction().rollback();
        }
        catch (SystemException e) {
            throw new QuarkusTransactionException(e);
        }
    }

    static void commit() {
        try {
            QuarkusTransactionImpl.getUserTransaction().commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new QuarkusTransactionException(e);
        }
    }

    static void setRollbackOnly() {
        try {
            QuarkusTransactionImpl.getUserTransaction().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private static jakarta.transaction.UserTransaction getUserTransaction() {
        if (cachedUserTransaction == null) {
            cachedUserTransaction = UserTransaction.userTransaction();
            return cachedUserTransaction;
        }
        return cachedUserTransaction;
    }

    private static jakarta.transaction.TransactionManager getTransactionManager() {
        if (cachedTransactionManager == null) {
            cachedTransactionManager = TransactionManager.transactionManager();
            return cachedTransactionManager;
        }
        return cachedTransactionManager;
    }
}

