/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.stm.deployment;

import com.arjuna.ats.internal.arjuna.coordinator.CheckedActionFactoryImple;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;
import com.arjuna.ats.internal.arjuna.utils.SocketProcessId;
import com.arjuna.ats.txoj.Lock;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.narayana.stm.runtime.NarayanaSTMRecorder;
import jakarta.inject.Inject;
import java.util.ArrayList;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.stm.annotations.Transactional;

class NarayanaSTMProcessor {
    private static final Logger log = Logger.getLogger((String)NarayanaSTMProcessor.class.getName());
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    NarayanaSTMProcessor() {
    }

    @BuildStep
    ReflectiveClassBuildItem registerFeature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.NARAYANA_STM));
        return ReflectiveClassBuildItem.builder((String[])new String[]{ShadowNoFileLockStore.class.getName(), CheckedActionFactoryImple.class.getName(), Lock.class.getName()}).methods().build();
    }

    @BuildStep
    public NativeImageSystemPropertyBuildItem substrateSystemPropertyBuildItem() {
        return new NativeImageSystemPropertyBuildItem("CoordinatorEnvironmentBean.transactionStatusManagerEnable", "false");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void configureRuntimeProperties(NarayanaSTMRecorder recorder, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInit) {
        recorder.disableTransactionStatusManager();
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(SocketProcessId.class.getName()));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(Lock.class.getName()));
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem stmProxies(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        DotName TRANSACTIONAL = DotName.createSimple((String)Transactional.class.getName());
        IndexView index = this.combinedIndexBuildItem.getIndex();
        ArrayList<String> proxies = new ArrayList<String>();
        for (AnnotationInstance stm : index.getAnnotations(TRANSACTIONAL)) {
            if (!AnnotationTarget.Kind.CLASS.equals((Object)stm.target().kind())) continue;
            DotName name = stm.target().asClass().name();
            proxies.add(name.toString());
            log.debugf("Registering transactional interface %s%n", (Object)name);
            for (ClassInfo ci : index.getAllKnownImplementors(name)) {
                reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)ci.name(), (Type.Kind)Type.Kind.CLASS)).source(this.getClass().getSimpleName() + " > " + ci.name()).build());
            }
        }
        String[] classNames = proxies.toArray(new String[0]);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames).methods().fields().build());
        return new NativeImageProxyDefinitionBuildItem(classNames);
    }
}

