/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.neo4j.runtime.Neo4jDriverProducer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.metrics.MetricsFactory;
import io.quarkus.runtime.ssl.SslContextConfiguration;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;

@Recorder
public class Neo4jDriverRecorder {
    private static final Logger log = Logger.getLogger(Neo4jDriverRecorder.class);
    private static Optional<ConnectionPoolMetrics> connectionPoolMetrics = Optional.empty();

    public RuntimeValue<Driver> initializeDriver(Neo4jConfiguration configuration, ShutdownContext shutdownContext) {
        String uri = configuration.uri;
        AuthToken authToken = AuthTokens.none();
        if (!configuration.authentication.disabled) {
            authToken = AuthTokens.basic((String)configuration.authentication.username, (String)configuration.authentication.password);
        }
        Config.ConfigBuilder configBuilder = Neo4jDriverRecorder.createBaseConfig();
        Neo4jDriverRecorder.configureSsl(configBuilder, configuration);
        Neo4jDriverRecorder.configurePoolSettings(configBuilder, configuration.pool);
        Driver driver = GraphDatabase.driver((String)uri, (AuthToken)authToken, (Config)configBuilder.build());
        shutdownContext.addShutdownTask(() -> ((Driver)driver).close());
        return new RuntimeValue((Object)driver);
    }

    public void configureNeo4jProducer(BeanContainer beanContainer, RuntimeValue<Driver> driverHolder) {
        Neo4jDriverProducer driverProducer = (Neo4jDriverProducer)beanContainer.instance(Neo4jDriverProducer.class, new Annotation[0]);
        driverProducer.initialize((Driver)driverHolder.getValue());
    }

    public Consumer<MetricsFactory> registerMetrics(Neo4jConfiguration configuration) {
        if (configuration.pool != null && configuration.pool.metricsEnabled) {
            return new Consumer<MetricsFactory>(){

                @Override
                public void accept(MetricsFactory metricsFactory) {
                    metricsFactory.builder("neo4j.acquired").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::acquired).orElse(0L));
                    metricsFactory.builder("neo4j.acquiring").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::acquiring).orElse(0));
                    metricsFactory.builder("neo4j.closed").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::closed).orElse(0L));
                    metricsFactory.builder("neo4j.created").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::created).orElse(0L));
                    metricsFactory.builder("neo4j.creating").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::creating).orElse(0));
                    metricsFactory.builder("neo4j.failedToCreate").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::failedToCreate).orElse(0L));
                    metricsFactory.builder("neo4j.timedOutToAcquire").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::timedOutToAcquire).orElse(0L));
                    metricsFactory.builder("neo4j.totalAcquisitionTime").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::totalAcquisitionTime).orElse(0L));
                    metricsFactory.builder("neo4j.totalConnectionTime").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::totalConnectionTime).orElse(0L));
                    metricsFactory.builder("neo4j.totalInUseCount").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::totalInUseCount).orElse(0L));
                    metricsFactory.builder("neo4j.totalInUseTime").buildCounter(() -> Neo4jDriverRecorder.this.getConnectionPoolMetrics().map(ConnectionPoolMetrics::totalInUseCount).orElse(0L));
                }
            };
        }
        return null;
    }

    private synchronized Optional<ConnectionPoolMetrics> getConnectionPoolMetrics() {
        if (!connectionPoolMetrics.isPresent()) {
            connectionPoolMetrics = ((Driver)Arc.container().instance(Driver.class, new Annotation[0]).get()).metrics().connectionPoolMetrics().stream().findFirst();
        }
        return connectionPoolMetrics;
    }

    private static Config.ConfigBuilder createBaseConfig() {
        Logging logging;
        Config.ConfigBuilder configBuilder = Config.builder();
        try {
            logging = Logging.slf4j();
        }
        catch (Exception e) {
            logging = Logging.javaUtilLogging((Level)Level.INFO);
        }
        configBuilder.withLogging(logging);
        return configBuilder;
    }

    private static void configureSsl(Config.ConfigBuilder configBuilder, Neo4jConfiguration configuration) {
        if (ImageInfo.inImageRuntimeCode() && !SslContextConfiguration.isSslNativeEnabled()) {
            log.warn((Object)"Native SSL is disabled, communication between this client and the Neo4j server cannot be encrypted.");
            configBuilder.withoutEncryption();
        } else if (configuration.encrypted) {
            configBuilder.withEncryption();
            configBuilder.withTrustStrategy(configuration.trustSettings.toInternalRepresentation());
        } else {
            configBuilder.withoutEncryption();
        }
    }

    private static void configurePoolSettings(Config.ConfigBuilder configBuilder, Neo4jConfiguration.Pool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring Neo4j pool settings with " + pool));
        }
        if (pool.logLeakedSessions) {
            configBuilder.withLeakedSessionsLogging();
        }
        configBuilder.withMaxConnectionPoolSize(pool.maxConnectionPoolSize);
        configBuilder.withConnectionLivenessCheckTimeout(pool.idleTimeBeforeConnectionTest.toMillis(), TimeUnit.MILLISECONDS);
        configBuilder.withMaxConnectionLifetime(pool.maxConnectionLifetime.toMillis(), TimeUnit.MILLISECONDS);
        configBuilder.withConnectionAcquisitionTimeout(pool.connectionAcquisitionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (pool.metricsEnabled) {
            configBuilder.withDriverMetrics();
        } else {
            configBuilder.withoutDriverMetrics();
        }
    }
}

