/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime.health;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.logging.Logger;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;

@Readiness
@ApplicationScoped
public class Neo4jHealthCheck
implements HealthCheck {
    private static final Logger log = Logger.getLogger(Neo4jHealthCheck.class);
    private static final String CYPHER = "RETURN 1 AS result";
    private static final String MESSAGE_HEALTH_CHECK_FAILED = "Neo4j health check failed";
    private static final String MESSAGE_SESSION_EXPIRED = "Neo4j session has expired, retrying one single time to retrieve server health.";
    private static final SessionConfig DEFAULT_SESSION_CONFIG = SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build();
    @Inject
    Driver driver;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Neo4j connection health check").up();
        try {
            ResultSummary resultSummary;
            try {
                resultSummary = this.runHealthCheckQuery();
            }
            catch (SessionExpiredException sessionExpiredException) {
                log.warn((Object)MESSAGE_SESSION_EXPIRED);
                resultSummary = this.runHealthCheckQuery();
            }
            return Neo4jHealthCheck.buildStatusUp(resultSummary, builder);
        }
        catch (Exception e) {
            return builder.down().withData("reason", e.getMessage()).build();
        }
    }

    private static HealthCheckResponse buildStatusUp(ResultSummary resultSummary, HealthCheckResponseBuilder builder) {
        ServerInfo serverInfo = resultSummary.server();
        builder.withData("server", serverInfo.version() + "@" + serverInfo.address());
        String databaseName = resultSummary.database().name();
        if (databaseName != null && !databaseName.trim().isEmpty()) {
            builder.withData("database", databaseName.trim());
        }
        return builder.build();
    }

    private ResultSummary runHealthCheckQuery() {
        try (Session session = this.driver.session(DEFAULT_SESSION_CONFIG);){
            ResultSummary resultSummary;
            ResultSummary resultSummary2 = resultSummary = session.run(CYPHER).consume();
            return resultSummary2;
        }
    }
}

