/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class Neo4jConfiguration {
    static final String DEFAULT_SERVER_URI = "bolt://localhost:7687";
    static final String DEFAULT_USERNAME = "neo4j";
    static final String DEFAULT_PASSWORD = "neo4j";
    @ConfigItem(defaultValue="bolt://localhost:7687")
    public String uri;
    @ConfigItem
    public Authentication authentication;
    @ConfigItem
    public Pool pool;

    @ConfigGroup
    static class Pool {
        @ConfigItem
        public boolean metricsEnabled;
        @ConfigItem
        public boolean logLeakedSessions;
        @ConfigItem(defaultValue="100")
        public int maxConnectionPoolSize;
        @ConfigItem(defaultValue="-0.001S")
        public Duration idleTimeBeforeConnectionTest;
        @ConfigItem(defaultValue="1H")
        public Duration maxConnectionLifetime;
        @ConfigItem(defaultValue="1M")
        public Duration connectionAcquisitionTimeout;

        Pool() {
        }

        public String toString() {
            return "Pool{metricsEnabled=" + this.metricsEnabled + ", logLeakedSessions=" + this.logLeakedSessions + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleTimeBeforeConnectionTest=" + this.idleTimeBeforeConnectionTest + ", maxConnectionLifetime=" + this.maxConnectionLifetime + ", connectionAcquisitionTimeout=" + this.connectionAcquisitionTimeout + '}';
        }
    }

    @ConfigGroup
    static class Authentication {
        @ConfigItem(defaultValue="neo4j")
        public String username;
        @ConfigItem(defaultValue="neo4j")
        public String password;
        @ConfigItem
        public boolean disabled = false;

        Authentication() {
        }
    }
}

