/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.channel.EventLoopGroup;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.quarkus.arc.deployment.RuntimeBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.JniBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateSystemPropertyBuildItem;
import io.quarkus.netty.BossEventLoopGroup;
import io.quarkus.netty.MainEventLoopGroup;
import io.quarkus.netty.deployment.EventLoopSupplierBuildItem;
import io.quarkus.netty.deployment.JBossNettyLoggerFactory;
import io.quarkus.netty.runtime.NettyRecorder;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;

class NettyProcessor {
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private static final Logger log = Logger.getLogger(NettyProcessor.class);

    NettyProcessor() {
    }

    @BuildStep
    public SubstrateSystemPropertyBuildItem limitMem() {
        return new SubstrateSystemPropertyBuildItem("sun.nio.ch.maxUpdateArraySize", "100");
    }

    @BuildStep
    public SystemPropertyBuildItem limitArenaSize() {
        return new SystemPropertyBuildItem("io.netty.allocator.maxOrder", "1");
    }

    @BuildStep
    SubstrateConfigBuildItem build(BuildProducer<JniBuildItem> jni) {
        boolean enableJni = false;
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioServerSocketChannel"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"java.util.LinkedHashMap"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"sun.nio.ch.SelectorImpl"}));
        SubstrateConfigBuildItem.Builder builder = SubstrateConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.allocator.maxOrder", "1").addRuntimeInitializedClass("io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslContext").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslClientContext").addRuntimeInitializedClass("io.netty.handler.ssl.util.ThreadLocalInsecureRandom").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil$HexUtil").addRuntimeInitializedClass("io.netty.buffer.PooledByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil").addRuntimeInitializedClass("io.netty.handler.ssl.ConscryptAlpnSslEngine").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ConnectionHandler").addNativeImageSystemProperty("io.netty.leakDetection.level", "DISABLED");
        try {
            Class.forName("io.netty.handler.codec.http.HttpObjectEncoder");
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2CodecUtil").addRuntimeInitializedClass("io.netty.handler.codec.http.HttpObjectEncoder").addRuntimeInitializedClass("io.netty.handler.codec.http2.DefaultHttp2FrameWriter").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty HTTP classes as they were not found");
        }
        try {
            Class.forName("io.netty.channel.unix.UnixChannel");
            enableJni = true;
            builder.addRuntimeInitializedClass("io.netty.channel.unix.Errors").addRuntimeInitializedClass("io.netty.channel.unix.FileDescriptor").addRuntimeInitializedClass("io.netty.channel.unix.IovArray").addRuntimeInitializedClass("io.netty.channel.unix.Limits");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty native unix classes as they were not found");
        }
        try {
            Class.forName("io.netty.channel.epoll.EpollMode");
            enableJni = true;
            builder.addRuntimeInitializedClass("io.netty.channel.epoll.Epoll").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventArray").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventLoop").addRuntimeInitializedClass("io.netty.channel.epoll.Native");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty native epoll classes as they were not found");
        }
        try {
            Class.forName("io.netty.channel.kqueue.AcceptFilter");
            enableJni = true;
            builder.addRuntimeInitializedClass("io.netty.channel.kqueue.KQueue").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventArray").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventLoop").addRuntimeInitializedClass("io.netty.channel.kqueue.Native");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty native kqueue classes as they were not found");
        }
        if (enableJni) {
            jni.produce((BuildItem)new JniBuildItem());
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void eagerlyInitClass(NettyRecorder recorder) {
        recorder.eagerlyInitChannelId();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createExecutors(BuildProducer<RuntimeBeanBuildItem> runtimeBeanBuildItemBuildProducer, Optional<EventLoopSupplierBuildItem> loopSupplierBuildItem, NettyRecorder recorder) {
        Supplier<EventLoopGroup> main;
        Supplier<EventLoopGroup> boss;
        if (loopSupplierBuildItem.isPresent()) {
            boss = loopSupplierBuildItem.get().getBossSupplier();
            main = loopSupplierBuildItem.get().getMainSupplier();
        } else {
            boss = recorder.createEventLoop(1);
            main = recorder.createEventLoop(0);
        }
        runtimeBeanBuildItemBuildProducer.produce((BuildItem)RuntimeBeanBuildItem.builder(EventLoopGroup.class).setSupplier(boss).setScope(ApplicationScoped.class).addQualifier(BossEventLoopGroup.class).build());
        runtimeBeanBuildItemBuildProducer.produce((BuildItem)RuntimeBeanBuildItem.builder(EventLoopGroup.class).setSupplier(main).setScope(ApplicationScoped.class).addQualifier(MainEventLoopGroup.class).build());
    }

    @BuildStep
    public RuntimeReinitializedClassBuildItem reinitScheduledFutureTask() {
        return new RuntimeReinitializedClassBuildItem("io.quarkus.netty.runtime.graal.Holder_io_netty_util_concurrent_ScheduledFutureTask");
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new JBossNettyLoggerFactory());
    }
}

