/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;

public class JBossNettyLoggerFactory
extends InternalLoggerFactory {
    protected InternalLogger newInstance(String name) {
        return new JBossNettyInternalLogger(name);
    }

    public static final class FormattingTuple {
        private final String message;
        private final Throwable throwable;

        FormattingTuple(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static final class MessageFormatter {
        private static final String DELIM_STR = "{}";
        private static final char ESCAPE_CHAR = '\\';

        static FormattingTuple format(String messagePattern, Object arg) {
            return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
        }

        static FormattingTuple format(String messagePattern, Object argA, Object argB) {
            return MessageFormatter.arrayFormat(messagePattern, new Object[]{argA, argB});
        }

        static FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
            Throwable throwable;
            if (argArray == null || argArray.length == 0) {
                return new FormattingTuple(messagePattern, null);
            }
            int lastArrIdx = argArray.length - 1;
            Object lastEntry = argArray[lastArrIdx];
            Throwable throwable2 = throwable = lastEntry instanceof Throwable ? (Throwable)lastEntry : null;
            if (messagePattern == null) {
                return new FormattingTuple(null, throwable);
            }
            int j = messagePattern.indexOf(DELIM_STR);
            if (j == -1) {
                return new FormattingTuple(messagePattern, throwable);
            }
            StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
            int i = 0;
            int L = 0;
            do {
                boolean notEscaped;
                boolean bl = notEscaped = j == 0 || messagePattern.charAt(j - 1) != '\\';
                if (notEscaped) {
                    sbuf.append(messagePattern, i, j);
                } else {
                    sbuf.append(messagePattern, i, j - 1);
                    notEscaped = j >= 2 && messagePattern.charAt(j - 2) == '\\';
                }
                i = j + 2;
                if (notEscaped) {
                    MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], null);
                    if (++L <= lastArrIdx) continue;
                    break;
                }
                sbuf.append(DELIM_STR);
            } while ((j = messagePattern.indexOf(DELIM_STR, i)) != -1);
            sbuf.append(messagePattern, i, messagePattern.length());
            return new FormattingTuple(sbuf.toString(), L <= lastArrIdx ? throwable : null);
        }

        private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Set<Object[]> seenSet) {
            if (o == null) {
                sbuf.append("null");
                return;
            }
            Class<?> objClass = o.getClass();
            if (!objClass.isArray()) {
                if (Number.class.isAssignableFrom(objClass)) {
                    if (objClass == Long.class) {
                        sbuf.append((Long)o);
                    } else if (objClass == Integer.class || objClass == Short.class || objClass == Byte.class) {
                        sbuf.append(((Number)o).intValue());
                    } else if (objClass == Double.class) {
                        sbuf.append((Double)o);
                    } else if (objClass == Float.class) {
                        sbuf.append(((Float)o).floatValue());
                    } else {
                        MessageFormatter.safeObjectAppend(sbuf, o);
                    }
                } else {
                    MessageFormatter.safeObjectAppend(sbuf, o);
                }
            } else {
                sbuf.append('[');
                if (objClass == boolean[].class) {
                    MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
                } else if (objClass == byte[].class) {
                    MessageFormatter.byteArrayAppend(sbuf, (byte[])o);
                } else if (objClass == char[].class) {
                    MessageFormatter.charArrayAppend(sbuf, (char[])o);
                } else if (objClass == short[].class) {
                    MessageFormatter.shortArrayAppend(sbuf, (short[])o);
                } else if (objClass == int[].class) {
                    MessageFormatter.intArrayAppend(sbuf, (int[])o);
                } else if (objClass == long[].class) {
                    MessageFormatter.longArrayAppend(sbuf, (long[])o);
                } else if (objClass == float[].class) {
                    MessageFormatter.floatArrayAppend(sbuf, (float[])o);
                } else if (objClass == double[].class) {
                    MessageFormatter.doubleArrayAppend(sbuf, (double[])o);
                } else {
                    MessageFormatter.objectArrayAppend(sbuf, (Object[])o, seenSet);
                }
                sbuf.append(']');
            }
        }

        private static void safeObjectAppend(StringBuilder sbuf, Object o) {
            try {
                String oAsString = o.toString();
                sbuf.append(oAsString);
            }
            catch (Throwable t) {
                System.err.println("SLF4J: Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
                t.printStackTrace();
                sbuf.append("[FAILED toString()]");
            }
        }

        private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Set<Object[]> seenSet) {
            if (a.length == 0) {
                return;
            }
            if (seenSet == null) {
                seenSet = new HashSet<Object[]>(a.length);
            }
            if (seenSet.add(a)) {
                MessageFormatter.deeplyAppendParameter(sbuf, a[0], seenSet);
                for (int i = 1; i < a.length; ++i) {
                    sbuf.append(", ");
                    MessageFormatter.deeplyAppendParameter(sbuf, a[i], seenSet);
                }
                seenSet.remove(a);
            } else {
                sbuf.append("...");
            }
        }

        private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void charArrayAppend(StringBuilder sbuf, char[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void intArrayAppend(StringBuilder sbuf, int[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void longArrayAppend(StringBuilder sbuf, long[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
            if (a.length == 0) {
                return;
            }
            sbuf.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                sbuf.append(a[i]);
            }
        }

        private MessageFormatter() {
        }
    }

    private static final class JBossNettyInternalLogger
    extends AbstractInternalLogger {
        final Logger log;

        JBossNettyInternalLogger(String name) {
            super(name);
            this.log = Logger.getLogger((String)name);
        }

        public boolean isTraceEnabled() {
            return this.log.isTraceEnabled();
        }

        public void trace(String msg) {
            if (this.isTraceEnabled()) {
                this.log.trace((Object)msg);
            }
        }

        public void trace(String format, Object arg) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.trace0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String format, Object argA, Object argB) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.trace0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String format, Object ... arguments) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arguments);
                this.trace0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String msg, Throwable t) {
            if (this.isTraceEnabled()) {
                this.trace0(msg, t);
            }
        }

        private void trace0(String msg, Throwable t) {
            this.log.trace((Object)msg, t);
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String msg) {
            if (this.isDebugEnabled()) {
                this.log.debug((Object)msg);
            }
        }

        public void debug(String format, Object arg) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.debug0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String format, Object argA, Object argB) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.debug0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String format, Object ... arguments) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arguments);
                this.debug0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String msg, Throwable t) {
            if (this.isDebugEnabled()) {
                this.debug0(msg, t);
            }
        }

        private void debug0(String msg, Throwable t) {
            this.log.debug((Object)msg, t);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String msg) {
            if (this.isInfoEnabled()) {
                this.log.info((Object)msg);
            }
        }

        public void info(String format, Object arg) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.info0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String format, Object argA, Object argB) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.info0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String format, Object ... arguments) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arguments);
                this.info0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String msg, Throwable t) {
            if (this.isInfoEnabled()) {
                this.info0(msg, t);
            }
        }

        private void info0(String msg, Throwable t) {
            this.log.info((Object)msg, t);
        }

        public boolean isWarnEnabled() {
            return this.log.isEnabled(Logger.Level.WARN);
        }

        public void warn(String msg) {
            if (this.isWarnEnabled()) {
                this.log.warn((Object)msg);
            }
        }

        public void warn(String format, Object arg) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.warn0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String format, Object ... arguments) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arguments);
                this.warn0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String format, Object argA, Object argB) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.warn0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String msg, Throwable t) {
            if (this.isWarnEnabled()) {
                this.warn0(msg, t);
            }
        }

        private void warn0(String msg, Throwable t) {
            this.log.warn((Object)msg, t);
        }

        public boolean isErrorEnabled() {
            return this.log.isEnabled(Logger.Level.ERROR);
        }

        public void error(String msg) {
            if (this.isErrorEnabled()) {
                this.log.error((Object)msg);
            }
        }

        public void error(String format, Object arg) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.error0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String format, Object argA, Object argB) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.error0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String format, Object ... arguments) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arguments);
                this.error0(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String msg, Throwable t) {
            if (this.isErrorEnabled()) {
                this.error0(msg, t);
            }
        }

        private void error0(String msg, Throwable t) {
            this.log.error((Object)msg, t);
        }
    }
}

