/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.devresource;

import io.quarkus.observability.devresource.DevResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class DevResources {
    private static final Logger log = Logger.getLogger(DevResources.class);
    private static List<DevResourceLifecycleManager> resources;
    private static Map<String, String> map;

    public static synchronized List<DevResourceLifecycleManager> resources() {
        if (resources == null) {
            log.info((Object)"Activating dev resources");
            resources = ServiceLoader.load(DevResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader()).stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparing(QuarkusTestResourceLifecycleManager::order)).collect(Collectors.toList());
            log.infof("Found dev resources: %s", resources);
        }
        return resources;
    }

    static synchronized Map<String, String> ensureStarted() {
        if (map == null) {
            try {
                for (DevResourceLifecycleManager res : DevResources.resources()) {
                    res.initDev();
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception initializing dev resource manager", (Throwable)e);
                throw e;
            }
            try {
                HashMap map = new HashMap();
                for (DevResourceLifecycleManager res : DevResources.resources()) {
                    Map resMap = res.start();
                    log.infof("Dev resource [%s] contributed config: %s", (Object)res.getClass().getSimpleName(), (Object)resMap);
                    map.putAll(resMap);
                }
                DevResources.map = Collections.unmodifiableMap(map);
            }
            catch (Exception e) {
                log.error((Object)"Exception starting dev resource", (Throwable)e);
                throw e;
            }
        }
        return map;
    }

    public static synchronized void stop() {
        if (map != null) {
            ListIterator<DevResourceLifecycleManager> i = DevResources.resources().listIterator(DevResources.resources().size());
            while (i.hasPrevious()) {
                try {
                    i.previous().stop();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception stopping dev resource", (Throwable)e);
                }
            }
            map = null;
        }
    }
}

