/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.devresource.lgtm;

import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.common.config.ModulesConfiguration;
import io.quarkus.observability.devresource.Container;
import io.quarkus.observability.devresource.testcontainers.ContainerResource;
import io.quarkus.observability.testcontainers.LgtmContainer;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;

public class LgtmResource
extends ContainerResource<LgtmContainer, LgtmConfig> {
    public LgtmConfig config(ModulesConfiguration configuration) {
        return configuration.lgtm();
    }

    public Container<LgtmConfig> container(LgtmConfig config, ModulesConfiguration root) {
        return this.set((GenericContainer)new LgtmContainer(config));
    }

    public Map<String, String> config(int privatePort, String host, int publicPort) {
        switch (privatePort) {
            case 3000: {
                return Map.of("quarkus.grafana.url", String.format("%s:%s", host, publicPort));
            }
            case 4317: 
            case 4318: {
                return Map.of("quarkus.otel-collector.url", String.format("%s:%s", host, publicPort));
            }
        }
        return Map.of();
    }

    protected LgtmContainer defaultContainer() {
        return new LgtmContainer();
    }

    public Map<String, String> doStart() {
        String host = ((LgtmContainer)this.container).getHost();
        return Map.of("quarkus.grafana.url", String.format("%s:%s", host, ((LgtmContainer)this.container).getGrafanaPort()), "quarkus.otel-collector.url", String.format("%s:%s", host, ((LgtmContainer)this.container).getOtlpPort()));
    }

    public int order() {
        return 10000;
    }
}

