/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.common.config;

import io.quarkus.observability.common.config.ContainerConfig;
import io.quarkus.observability.common.config.OverrideProperty;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerConfigUtil {
    public static boolean isEqual(ContainerConfig cc1, ContainerConfig cc2) {
        Method[] methods;
        Class<?> c2;
        Class<?> c1 = cc1.getClass();
        if (!c1.equals(c2 = cc1.getClass())) {
            return false;
        }
        for (Method m : methods = ContainerConfigUtil.getMethods(c1)) {
            Object v2;
            Object v1 = ContainerConfigUtil.invoke(m, cc1);
            if (Objects.equals(v1, v2 = ContainerConfigUtil.invoke(m, cc2))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, Object> propertiesToOverride(ContainerConfig config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method m : ContainerConfigUtil.getMethods(config.getClass())) {
            OverrideProperty override = m.getAnnotation(OverrideProperty.class);
            if (override == null) continue;
            String key = override.value();
            Object value = ContainerConfigUtil.invoke(m, config);
            if (value instanceof Optional) {
                Optional optional = (Optional)value;
                optional.ifPresent(o -> map.put(key, o));
                continue;
            }
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private static Method[] getMethods(Class<?> c1) {
        Class i = Arrays.stream(c1.getInterfaces()).filter(ContainerConfig.class::isAssignableFrom).findFirst().orElseThrow(() -> new IllegalArgumentException("Missing ContainerConfig based interface"));
        return i.getMethods();
    }

    private static Object invoke(Method m, Object target) {
        try {
            return m.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

