/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.observability.common.config.ContainerConfig;
import io.quarkus.observability.common.config.ContainerConfigUtil;
import io.quarkus.observability.common.config.ModulesConfiguration;
import io.quarkus.observability.deployment.devui.ObservabilityDevServicesConfigBuildItem;
import io.quarkus.observability.devresource.Container;
import io.quarkus.observability.devresource.DevResourceLifecycleManager;
import io.quarkus.observability.devresource.DevResources;
import io.quarkus.observability.devresource.ExtensionsCatalog;
import io.quarkus.observability.runtime.config.ObservabilityConfiguration;
import io.quarkus.runtime.LaunchMode;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class, IsEnabled.class})
class ObservabilityDevServiceProcessor {
    private static final Logger log = Logger.getLogger(ObservabilityDevServiceProcessor.class);
    private static final Map<String, DevServicesResultBuildItem.RunningDevService> devServices = new ConcurrentHashMap<String, DevServicesResultBuildItem.RunningDevService>();
    private static final Map<String, ContainerConfig> capturedDevServicesConfigurations = new ConcurrentHashMap<String, ContainerConfig>();
    private static final Map<String, Boolean> firstStart = new ConcurrentHashMap<String, Boolean>();
    private static final DotName OTLP_REGISTRY = DotName.createSimple((String)"io.micrometer.registry.otlp.OtlpMeterRegistry");

    ObservabilityDevServiceProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.OBSERVABILITY);
    }

    private String devId(DevResourceLifecycleManager<?> dev) {
        String sn;
        int p = (sn = dev.getClass().getSimpleName()).indexOf("Resource");
        return sn.substring(0, p != -1 ? p : sn.length());
    }

    @BuildStep
    public void startContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, ObservabilityConfiguration configuration, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, BuildProducer<DevServicesResultBuildItem> services, Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsConfiguration, BuildProducer<ObservabilityDevServicesConfigBuildItem> configBuildProducer) {
        if (!configuration.enabled()) {
            log.infof("Observability dev services are disabled in config", new Object[0]);
            return;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Please get a working Docker instance");
            return;
        }
        List resources = DevResources.resources();
        resources.stream().collect(Collectors.toMap(this::devId, Function.identity()));
        Stream stream = resources.stream();
        if (configuration.parallel()) {
            stream = (Stream)stream.parallel();
        }
        stream.forEach(dev -> {
            final String devId = this.devId((DevResourceLifecycleManager<?>)dev);
            DevServicesResultBuildItem.RunningDevService devService = devServices.get(devId);
            ContainerConfig currentDevServicesConfiguration = dev.config((ModulesConfiguration)configuration, new ExtensionsCatalog(capabilities.isPresent("io.quarkus.opentelemetry.tracer"), ObservabilityDevServiceProcessor.hasMicrometerOtlp(metricsConfiguration)));
            if (devService != null) {
                ContainerConfig capturedDevServicesConfiguration = capturedDevServicesConfigurations.get(devId);
                boolean equalConfig = ContainerConfigUtil.isEqual((ContainerConfig)capturedDevServicesConfiguration, (ContainerConfig)currentDevServicesConfiguration);
                if (equalConfig) {
                    log.debugf("Equal config, re-using existing %s container", (Object)devId);
                    services.produce((BuildItem)devService.toBuildItem());
                    return;
                }
                try {
                    devService.close();
                }
                catch (Throwable e) {
                    log.errorf("Failed to stop %s container", (Object)devId, (Object)e);
                }
            }
            devServices.remove(devId);
            capturedDevServicesConfigurations.put(devId, currentDevServicesConfiguration);
            StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + devId + " Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem, s -> false, s -> s.contains(this.getClass().getSimpleName()) || s.contains("Resource") || s.contains("Container"));
            try {
                DevServicesResultBuildItem.RunningDevService newDevService = this.startContainer(devId, (DevResourceLifecycleManager<ContainerConfig>)dev, currentDevServicesConfiguration, (ModulesConfiguration)configuration, devServicesConfig.timeout);
                if (newDevService == null) {
                    compressor.closeAndDumpCaptured();
                    return;
                }
                compressor.close();
                devService = newDevService;
                devServices.put(devId, newDevService);
                configBuildProducer.produce((BuildItem)new ObservabilityDevServicesConfigBuildItem(newDevService.getConfig()));
            }
            catch (Throwable t) {
                compressor.closeAndDumpCaptured();
                throw new RuntimeException(t);
            }
            if (firstStart.computeIfAbsent(devId, x -> true).booleanValue()) {
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        DevServicesResultBuildItem.RunningDevService current = devServices.get(devId);
                        if (current != null) {
                            try {
                                current.close();
                            }
                            catch (Throwable t) {
                                log.errorf("Failed to stop %s container", (Object)devId, (Object)t);
                            }
                        }
                        firstStart.remove(devId);
                        devServices.remove(devId);
                        capturedDevServicesConfigurations.remove(devId);
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            services.produce((BuildItem)devService.toBuildItem());
        });
    }

    private static boolean hasMicrometerOtlp(Optional<MetricsCapabilityBuildItem> metricsConfiguration) {
        if (metricsConfiguration.isPresent() && metricsConfiguration.get().metricsSupported("micrometer")) {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)OTLP_REGISTRY.toString());
        }
        return false;
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(final String devId, final DevResourceLifecycleManager<ContainerConfig> dev, final ContainerConfig capturedDevServicesConfiguration, final ModulesConfiguration root, final Optional<Duration> timeout) {
        if (!capturedDevServicesConfiguration.enabled()) {
            log.debugf("Not starting Dev Services for %s as it has been disabled in the config", (Object)devId);
            return null;
        }
        if (!dev.enable()) {
            return null;
        }
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultContainerSupplier = new Supplier<DevServicesResultBuildItem.RunningDevService>(){

            @Override
            public DevServicesResultBuildItem.RunningDevService get() {
                Container container = dev.container(capturedDevServicesConfiguration, root);
                timeout.ifPresent(arg_0 -> ((Container)container).withStartupTimeout(arg_0));
                Map config = dev.start();
                log.infof("Dev Service %s started, config: %s", (Object)devId, (Object)config);
                return new DevServicesResultBuildItem.RunningDevService(Feature.OBSERVABILITY.getName(), container.getContainerId(), container.closeableCallback(capturedDevServicesConfiguration.serviceName()), config);
            }
        };
        final LinkedHashMap config = new LinkedHashMap();
        ContainerLocator containerLocator = new ContainerLocator(capturedDevServicesConfiguration.label(), 0);
        return containerLocator.locateContainer(capturedDevServicesConfiguration.serviceName(), capturedDevServicesConfiguration.shared(), LaunchMode.current(), (p, ca) -> config.putAll(dev.config(p.intValue(), ca.getHost(), ca.getPort()))).map(new Function<String, DevServicesResultBuildItem.RunningDevService>(){

            @Override
            public DevServicesResultBuildItem.RunningDevService apply(String cid) {
                log.infof("Dev Service %s re-used, config: %s", (Object)devId, (Object)config);
                return new DevServicesResultBuildItem.RunningDevService(Feature.OBSERVABILITY.getName(), cid, null, config);
            }
        }).orElseGet(defaultContainerSupplier);
    }

    public static class IsEnabled
    implements BooleanSupplier {
        ObservabilityConfiguration config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled() && !this.config.devResources();
        }
    }
}

