/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.deployment.devui;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.observability.deployment.devui.ObservabilityDevServicesConfigBuildItem;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class ObservabilityDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    void createVersion(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer, BuildProducer<FooterPageBuildItem> footerProducer, List<ObservabilityDevServicesConfigBuildItem> configProps) {
        for (ObservabilityDevServicesConfigBuildItem cp : configProps) {
            Map<String, String> runtimeConfig = cp.getConfig();
            String grafanaUrl = runtimeConfig.getOrDefault("grafana.endpoint", "");
            if (!StringUtils.isNotEmpty((CharSequence)grafanaUrl)) continue;
            CardPageBuildItem card = new CardPageBuildItem();
            grafanaUrl = StringUtils.prependIfMissing((String)grafanaUrl, (CharSequence)"http://", (CharSequence[])new CharSequence[0]);
            card.addPage((PageBuilder)Page.externalPageBuilder((String)"Grafana UI").url(grafanaUrl, grafanaUrl).doNotEmbed().isHtmlContent().icon("font-awesome-solid:chart-line"));
            ExternalPageBuilder otelPage = (ExternalPageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"OpenTelemetry Port").icon("font-awesome-solid:binoculars")).doNotEmbed().url("https://opentelemetry.io/").staticLabel(StringUtils.substringAfterLast((String)runtimeConfig.getOrDefault("otel-collector.url", "0"), (String)":"));
            card.addPage((PageBuilder)otelPage);
            card.setCustomCard("qwc-lgtm-card.js");
            cardPageBuildItemBuildProducer.produce((BuildItem)card);
            WebComponentPageBuilder mailLogPageBuilder = ((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:chart-line")).title("LGTM")).componentLink("qwc-lgtm-log.js");
            footerProducer.produce((BuildItem)new FooterPageBuildItem(new PageBuilder[]{mailLogPageBuilder}));
        }
    }
}

