/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.GrafanaConfig;
import io.quarkus.observability.testcontainers.ObservabilityContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public abstract class GrafanaContainer<T extends GrafanaContainer<T, C>, C extends GrafanaConfig>
extends ObservabilityContainer<T, C> {
    protected static final String DATASOURCES_PATH = "/etc/grafana/provisioning/datasources/custom.yaml";
    protected C config;

    public GrafanaContainer(C config) {
        super(config);
        this.config = config;
        this.withEnv("GF_SECURITY_ADMIN_USER", config.username());
        this.withEnv("GF_SECURITY_ADMIN_PASSWORD", config.password());
        this.addExposedPort(config.grafanaPort());
        this.waitingFor(this.grafanaWaitStrategy());
    }

    public int getGrafanaPort() {
        return this.getMappedPort(this.config.grafanaPort());
    }

    private WaitStrategy grafanaWaitStrategy() {
        return new HttpWaitStrategy().forPath("/").forPort(this.config.grafanaPort()).forStatusCode(200).withStartupTimeout(this.config.timeout());
    }
}

