/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.AbstractGrafanaConfig;
import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.testcontainers.GrafanaContainer;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.utility.MountableFile;

public class LgtmContainer
extends GrafanaContainer<LgtmContainer, LgtmConfig> {
    protected static final String LGTM_NETWORK_ALIAS = "ltgm.testcontainer.docker";
    protected static final String PROMETHEUS_CONFIG = "    global:\n      scrape_interval: 10s\n      evaluation_interval: 10s\n    storage:\n      tsdb:\n        out_of_order_time_window: 10m\n    scrape_configs:\n      - job_name: '%s'\n        metrics_path: '%s%s'\n        scrape_interval: 10s\n        static_configs:\n          - targets: ['%s:%d']\n";

    public LgtmContainer() {
        this(new LgtmConfigImpl());
    }

    public LgtmContainer(LgtmConfig config) {
        super(config);
        this.addExposedPorts(new int[]{4317, 4318});
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-prometheus.json"), "/otel-lgtm/grafana-dashboard-red-metrics-classic.json");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-otlp.json"), "/otel-lgtm/grafana-dashboard-red-metrics-native.json");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/empty.json"), "/otel-lgtm/grafana-dashboard-jvm-metrics.json");
        this.addFileToContainer(this.getPrometheusConfig().getBytes(), "/otel-lgtm/prometheus.yaml");
    }

    @Override
    protected String prefix() {
        return "LGTM";
    }

    public String getOtlpProtocol() {
        return ((LgtmConfig)this.config).otlpProtocol();
    }

    public int getOtlpPort() {
        int port = this.getOtlpPortInternal();
        return this.getMappedPort(port);
    }

    private int getOtlpPortInternal() {
        if ("grpc".equalsIgnoreCase(this.getOtlpProtocol())) {
            return 4317;
        }
        if ("http/protobuf".equals(this.getOtlpProtocol())) {
            return 4318;
        }
        throw new IllegalArgumentException("Unsupported OTEL protocol: " + this.getOtlpProtocol());
    }

    private String getPrometheusConfig() {
        Config runtimeConfig = ConfigProvider.getConfig();
        String rootPath = runtimeConfig.getOptionalValue("quarkus.management.root-path", String.class).orElse("/q");
        String metricsPath = runtimeConfig.getOptionalValue("quarkus.management.metrics.path", String.class).orElse("/metrics");
        int httpPort = runtimeConfig.getOptionalValue("quarkus.http.port", Integer.class).orElse(0);
        return String.format(PROMETHEUS_CONFIG, ((LgtmConfig)this.config).serviceName(), rootPath, metricsPath, "host.docker.internal", httpPort);
    }

    protected static class LgtmConfigImpl
    extends AbstractGrafanaConfig
    implements LgtmConfig {
        public LgtmConfigImpl() {
            this("docker.io/grafana/otel-lgtm:0.7.5");
        }

        public LgtmConfigImpl(String imageName) {
            super(imageName);
        }

        public Optional<Set<String>> networkAliases() {
            return Optional.of(Set.of("lgtm", LgtmContainer.LGTM_NETWORK_ALIAS));
        }

        public String otlpProtocol() {
            return "http/protobuf";
        }
    }
}

