/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.devservices.common.JBossLoggingConsumer;
import io.quarkus.observability.common.config.ContainerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public abstract class ObservabilityContainer<T extends ObservabilityContainer<T, C>, C extends ContainerConfig>
extends GenericContainer<T> {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public ObservabilityContainer(C config) {
        super(DockerImageName.parse((String)config.imageName()));
        this.withLogConsumer(this.frameConsumer());
        this.withLabel(config.label(), config.serviceName());
        Optional aliases = config.networkAliases();
        aliases.map(s -> s.toArray(new String[0])).ifPresent(arg_0 -> ((ObservabilityContainer)this).withNetworkAliases(arg_0));
        if (config.shared()) {
            this.withNetwork(Network.SHARED);
        }
    }

    protected abstract String prefix();

    protected Consumer<OutputFrame> frameConsumer() {
        return new JBossLoggingConsumer(this.log).withPrefix(this.prefix());
    }

    protected byte[] getResourceAsBytes(String resource) {
        byte[] byArray;
        block8: {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
            try {
                byArray = in.readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            in.close();
        }
        return byArray;
    }

    protected void addFileToContainer(byte[] content, String pathInContainer) {
        this.log.infof("Content [%s]: \n%s", (Object)pathInContainer, (Object)new String(content, StandardCharsets.UTF_8));
        this.withCopyToContainer(Transferable.of((byte[])content, (int)511), pathInContainer);
    }

    public void start() {
        this.log.infof("Starting %s ...", (Object)this.prefix());
        super.start();
    }

    public void stop() {
        this.log.infof("Stopping %s...", (Object)this.prefix());
        super.stop();
    }
}

