/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.AbstractGrafanaConfig;
import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.testcontainers.GrafanaContainer;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class LgtmContainer
extends GrafanaContainer<LgtmContainer, LgtmConfig> {
    protected static final String LGTM_NETWORK_ALIAS = "ltgm.testcontainer.docker";
    protected static final String PROMETHEUS_CONFIG = "---\notlp:\n  # Recommended attributes to be promoted to labels.\n  promote_resource_attributes:\n    - service.instance.id\n    - service.name\n    - service.namespace\n    - service.version\n    - cloud.availability_zone\n    - cloud.region\n    - container.name\n    - deployment.environment.name\n    - k8s.cluster.name\n    - k8s.container.name\n    - k8s.cronjob.name\n    - k8s.daemonset.name\n    - k8s.deployment.name\n    - k8s.job.name\n    - k8s.namespace.name\n    - k8s.pod.name\n    - k8s.replicaset.name\n    - k8s.statefulset.name\nstorage:\n  tsdb:\n    # A 10min time window is enough because it can easily absorb retries and network delays.\n    out_of_order_time_window: 10m\nglobal:\n  scrape_interval: 5s\n  evaluation_interval: 5s\nscrape_configs:\n  - job_name: '%s'\n    metrics_path: '%s%s'\n    scrape_interval: 5s\n    static_configs:\n      - targets: ['%s:%d']\n";
    protected static final String DASHBOARDS_CONFIG = "apiVersion: 1\n\nproviders:\n  - name: \"Quarkus Micrometer Prometheus\"\n    type: file\n    options:\n      path: /otel-lgtm/grafana-dashboard-quarkus-micrometer-prometheus.json\n      foldersFromFilesStructure: false\n  - name: \"Quarkus Micrometer with OTLP output\"\n    type: file\n    options:\n      path: /otel-lgtm/grafana-dashboard-quarkus-micrometer-otlp.json\n      foldersFromFilesStructure: false\n";

    public LgtmContainer() {
        this(new LgtmConfigImpl());
    }

    public LgtmContainer(LgtmConfig config) {
        super(config);
        this.addExposedPorts(new int[]{4317, 4318});
        this.addFileToContainer(DASHBOARDS_CONFIG.getBytes(), "/otel-lgtm/grafana/conf/provisioning/dashboards/grafana-dashboards.yaml");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-prometheus.json"), "/otel-lgtm/grafana-dashboard-quarkus-micrometer-prometheus.json");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-otlp.json"), "/otel-lgtm/grafana-dashboard-quarkus-micrometer-otlp.json");
        this.addFileToContainer(this.getPrometheusConfig().getBytes(), "/otel-lgtm/prometheus.yaml");
    }

    @Override
    protected WaitStrategy waitStrategy() {
        return new WaitAllStrategy().withStartupTimeout(((LgtmConfig)this.config).timeout()).withStrategy(super.waitStrategy()).withStrategy(Wait.forLogMessage((String)".*The OpenTelemetry collector and the Grafana LGTM stack are up and running.*", (int)1).withStartupTimeout(((LgtmConfig)this.config).timeout()));
    }

    @Override
    protected String prefix() {
        return "LGTM";
    }

    @Override
    protected Predicate<OutputFrame> getLoggingFilter() {
        return new LgtmLoggingFilter();
    }

    public String getOtlpProtocol() {
        return ((LgtmConfig)this.config).otlpProtocol();
    }

    public int getOtlpPort() {
        int port = this.getOtlpPortInternal();
        return this.getMappedPort(port);
    }

    private int getOtlpPortInternal() {
        if ("grpc".equalsIgnoreCase(this.getOtlpProtocol())) {
            return 4317;
        }
        if ("http/protobuf".equals(this.getOtlpProtocol())) {
            return 4318;
        }
        throw new IllegalArgumentException("Unsupported OTEL protocol: " + this.getOtlpProtocol());
    }

    private String getPrometheusConfig() {
        Config runtimeConfig = ConfigProvider.getConfig();
        String rootPath = runtimeConfig.getOptionalValue("quarkus.management.root-path", String.class).orElse("/q");
        String metricsPath = runtimeConfig.getOptionalValue("quarkus.management.metrics.path", String.class).orElse("/metrics");
        int httpPort = runtimeConfig.getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
        return String.format(PROMETHEUS_CONFIG, ((LgtmConfig)this.config).serviceName(), rootPath, metricsPath, "host.docker.internal", httpPort);
    }

    protected static class LgtmConfigImpl
    extends AbstractGrafanaConfig
    implements LgtmConfig {
        public LgtmConfigImpl() {
            this("docker.io/grafana/otel-lgtm:0.8.2");
        }

        public LgtmConfigImpl(String imageName) {
            super(imageName);
        }

        public Optional<Set<String>> networkAliases() {
            return Optional.of(Set.of("lgtm", LgtmContainer.LGTM_NETWORK_ALIAS));
        }

        public String otlpProtocol() {
            return "http/protobuf";
        }
    }

    protected static class LgtmLoggingFilter
    implements Predicate<OutputFrame> {
        protected LgtmLoggingFilter() {
        }

        @Override
        public boolean test(OutputFrame outputFrame) {
            String line = outputFrame.getUtf8StringWithoutLineEnding();
            return !line.startsWith("Waiting for") || !line.endsWith("to start up...");
        }
    }
}

