/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.deployment;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.oidc.client.NamedOidcClient;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.deployment.AccessTokenInstanceBuildItem;
import io.quarkus.oidc.client.deployment.OidcClientFilterDeploymentHelper;
import io.quarkus.oidc.client.deployment.OidcClientNamesBuildItem;
import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import io.quarkus.oidc.client.runtime.OidcClientBuildTimeConfig;
import io.quarkus.oidc.client.runtime.OidcClientRecorder;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.client.runtime.TokensHelper;
import io.quarkus.oidc.client.runtime.TokensProducer;
import io.quarkus.oidc.token.propagation.AccessToken;
import io.quarkus.tls.TlsRegistryBuildItem;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcClientBuildStep {
    private static final DotName ACCESS_TOKEN = DotName.createSimple((String)AccessToken.class.getName());

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.OIDC_CLIENT);
    }

    @BuildStep
    void registerProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(TokensProducer.class));
    }

    @BuildStep
    void runtimeInitializeTokenHelper(BuildProducer<RuntimeInitializedClassBuildItem> runtime) {
        runtime.produce((BuildItem)new RuntimeInitializedClassBuildItem(TokensHelper.class.getName()));
    }

    @BuildStep
    void extractInjectedOidcClientNames(ApplicationArchivesBuildItem beanArchiveIndex, BuildProducer<OidcClientNamesBuildItem> oidcClientNames) {
        oidcClientNames.produce((BuildItem)new OidcClientNamesBuildItem(this.oidcClientNamesOf(beanArchiveIndex)));
    }

    private Set<String> oidcClientNamesOf(ApplicationArchivesBuildItem beanArchiveIndex) {
        return beanArchiveIndex.getAllApplicationArchives().stream().map(ApplicationArchive::getIndex).flatMap(archive -> archive.getAnnotations(DotName.createSimple((String)NamedOidcClient.class.getName())).stream()).map(annotation -> annotation.value().asString()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void setup(OidcClientsConfig oidcConfig, OidcClientRecorder recorder, CoreVertxBuildItem vertxBuildItem, OidcClientNamesBuildItem oidcClientNames, TlsRegistryBuildItem tlsRegistry, BuildProducer<SyntheticBeanBuildItem> syntheticBean) {
        OidcClients clients = recorder.setup(oidcConfig, vertxBuildItem.getVertx(), tlsRegistry.registry());
        syntheticBean.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcClient.class).unremovable()).types(new Class[]{OidcClient.class})).supplier(recorder.createOidcClientBean(clients)).scope(Singleton.class)).setRuntimeInit().destroyer(BeanDestroyer.CloseableDestroyer.class)).done());
        syntheticBean.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcClients.class).unremovable()).types(new Class[]{OidcClients.class})).supplier(recorder.createOidcClientsBean(clients)).scope(Singleton.class)).setRuntimeInit().destroyer(BeanDestroyer.CloseableDestroyer.class)).done());
        this.produceNamedOidcClientBeans(syntheticBean, oidcClientNames.oidcClientNames(), recorder, clients);
    }

    private void produceNamedOidcClientBeans(BuildProducer<SyntheticBeanBuildItem> syntheticBean, Set<String> injectedOidcClientNames, OidcClientRecorder recorder, OidcClients clients) {
        injectedOidcClientNames.stream().map(clientName -> this.syntheticNamedOidcClientBeanFor((String)clientName, recorder, clients)).forEach(arg_0 -> syntheticBean.produce(arg_0));
    }

    private SyntheticBeanBuildItem syntheticNamedOidcClientBeanFor(String clientName, OidcClientRecorder recorder, OidcClients clients) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcClient.class).unremovable()).types(new Class[]{OidcClient.class})).supplier(recorder.createOidcClientBean(clients, clientName)).scope(Singleton.class)).addQualifier().annotation(NamedOidcClient.class).addValue("value", (Object)clientName).done()).setRuntimeInit().destroyer(BeanDestroyer.CloseableDestroyer.class)).done();
    }

    @BuildStep
    public void createNonDefaultTokensProducers(BuildProducer<GeneratedBeanBuildItem> generatedBean, OidcClientNamesBuildItem oidcClientNames) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBean);
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)DotName.createSimple((String)TokensProducer.class.getName()));
        for (String oidcClientName : oidcClientNames.oidcClientNames()) {
            this.createNamedTokensProducerFor((ClassOutput)classOutput, targetPackage, oidcClientName);
        }
    }

    @BuildStep
    public List<AccessTokenInstanceBuildItem> collectAccessTokenInstances(CombinedIndexBuildItem index) {
        record ItemBuilder(AnnotationInstance instance) {
            private String toClientName() {
                AnnotationValue value = this.instance.value("exchangeTokenClient");
                return value == null || value.asString().equals("Default") ? "" : value.asString();
            }

            private boolean toExchangeToken() {
                return this.instance.value("exchangeTokenClient") != null;
            }

            private AccessTokenInstanceBuildItem build() {
                return new AccessTokenInstanceBuildItem(this.toClientName(), this.toExchangeToken(), this.instance.target());
            }
        }
        return index.getIndex().getAnnotations(ACCESS_TOKEN).stream().map(x$0 -> new ItemBuilder((AnnotationInstance)x$0)).map(ItemBuilder::build).toList();
    }

    private String createNamedTokensProducerFor(ClassOutput classOutput, String targetPackage, String oidcClientName) {
        String generatedName = targetPackage + "TokensProducer_" + OidcClientFilterDeploymentHelper.sanitize(oidcClientName);
        try (ClassCreator tokensProducer = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AbstractTokensProducer.class).build();){
            tokensProducer.addAnnotation(DotNames.SINGLETON.toString());
            try (MethodCreator produceMethod = tokensProducer.getMethodCreator("produceTokens", Tokens.class, new Class[0]);){
                produceMethod.setModifiers(1);
                produceMethod.addAnnotation(DotNames.PRODUCES.toString());
                produceMethod.addAnnotation(NamedOidcClient.class.getName()).addValue("value", (Object)oidcClientName);
                produceMethod.addAnnotation(RequestScoped.class.getName());
                ResultHandle tokensResult = produceMethod.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractTokensProducer.class, (String)"awaitTokens", Tokens.class, (Class[])new Class[0]), produceMethod.getThis(), new ResultHandle[0]);
                produceMethod.returnValue(tokensResult);
            }
            try (MethodCreator clientIdMethod = tokensProducer.getMethodCreator("clientId", Optional.class, new Class[0]);){
                clientIdMethod.setModifiers(4);
                clientIdMethod.returnValue(clientIdMethod.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{clientIdMethod.load(oidcClientName)}));
            }
        }
        return generatedName.replace('/', '.');
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcClientBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

