/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.graphql;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.oidc.client.graphql.runtime.OidcClientGraphQLConfig;
import io.quarkus.oidc.client.graphql.runtime.OidcGraphQLClientIntegrationRecorder;
import io.quarkus.smallrye.graphql.client.deployment.GraphQLClientConfigInitializedBuildItem;
import java.util.HashMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class OidcGraphQLClientIntegrationProcessor {
    private static final DotName GRAPHQL_CLIENT_API = DotName.createSimple((String)"io.smallrye.graphql.client.typesafe.api.GraphQLClientApi");
    private static final String OIDC_CLIENT_FILTER = "io.quarkus.oidc.client.filter.OidcClientFilter";

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.OIDC_CLIENT_GRAPHQL_CLIENT_INTEGRATION));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void initialize(BeanContainerBuildItem containerBuildItem, OidcGraphQLClientIntegrationRecorder recorder, OidcClientGraphQLConfig config, BeanArchiveIndexBuildItem index, GraphQLClientConfigInitializedBuildItem configInitialized) {
        HashMap<String, String> configKeysToOidcClients = new HashMap<String, String>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            String actualConfigKey;
            ClassInfo clazz = annotation.target().asClass();
            AnnotationInstance oidcClient = clazz.annotation(OIDC_CLIENT_FILTER);
            if (oidcClient == null) continue;
            String oidcClientName = oidcClient.valueWithDefault(index.getIndex(), "value").asString();
            AnnotationValue configKeyValue = annotation.value("configKey");
            String configKey = configKeyValue != null ? configKeyValue.asString() : null;
            String string = actualConfigKey = configKey != null && !configKey.equals("") ? configKey : clazz.name().toString();
            if (oidcClientName == null || oidcClientName.isEmpty()) continue;
            configKeysToOidcClients.put(actualConfigKey, oidcClientName);
        }
        recorder.enhanceGraphQLClientConfigurationWithOidc(configKeysToOidcClients, (String)config.clientName.orElse(null));
    }
}

