/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration.deployment.devservices.keycloak;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.devservices.keycloak.KeycloakAdminPageBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfigurator;
import io.quarkus.devservices.keycloak.KeycloakDevServicesRequiredBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.oidc.client.registration.deployment.OidcClientRegistrationBuildStep;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={OidcClientRegistrationBuildStep.IsEnabled.class, GlobalDevServicesConfig.Enabled.class})
public class KeycloakDevServiceRequiredBuildStep {
    private static final String OIDC_CLIENT_REG_AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc-client-registration.auth-server-url";

    @BuildStep
    KeycloakDevServicesRequiredBuildItem requireKeycloakDevService() {
        KeycloakDevServicesConfigurator devServicesConfigurator = new KeycloakDevServicesConfigurator(){

            public Map<String, String> createProperties(KeycloakDevServicesConfigurator.ConfigPropertiesContext ctx) {
                return Map.of(KeycloakDevServiceRequiredBuildStep.OIDC_CLIENT_REG_AUTH_SERVER_URL_CONFIG_KEY, ctx.authServerInternalUrl());
            }

            public void customizeDefaultRealm(RealmRepresentation realmRepresentation) {
                if (KeycloakDevServiceRequiredBuildStep.getInitialToken() == null) {
                    realmRepresentation.setRegistrationAllowed(Boolean.valueOf(true));
                    realmRepresentation.setRegistrationFlow("registration");
                    if (realmRepresentation.getComponents() == null) {
                        realmRepresentation.setComponents(new MultivaluedHashMap());
                    }
                    ComponentExportRepresentation componentExportRepresentation = new ComponentExportRepresentation();
                    componentExportRepresentation.setName("Full Scope Disabled");
                    componentExportRepresentation.setProviderId("scope");
                    componentExportRepresentation.setSubType("anonymous");
                    realmRepresentation.getComponents().put((Object)"org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy", List.of(componentExportRepresentation));
                }
            }
        };
        return KeycloakDevServicesRequiredBuildItem.of((KeycloakDevServicesConfigurator)devServicesConfigurator, (String)OIDC_CLIENT_REG_AUTH_SERVER_URL_CONFIG_KEY, (String[])new String[0]);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    KeycloakAdminPageBuildItem addCardWithLinkToKeycloakAdmin() {
        return new KeycloakAdminPageBuildItem(new CardPageBuildItem());
    }

    private static String getInitialToken() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.oidc-client-registration.initial-token", String.class).orElse(null);
    }
}

