/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.registration.runtime;

import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.oidc.client.registration.ClientMetadata;
import io.quarkus.oidc.client.registration.OidcClientRegistrationConfig;
import io.quarkus.oidc.client.registration.RegisteredClient;
import io.quarkus.oidc.client.registration.runtime.OidcClientRegistrationException;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

public class RegisteredClientImpl
implements RegisteredClient {
    private static final Logger LOG = Logger.getLogger(RegisteredClientImpl.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private static final Set<String> PRIVATE_PROPERTIES = Set.of("client_secret_expires_at", "client_id_issued_at");
    private static final OidcRequestContextProperties DEFAULT_REQUEST_PROPS = new OidcRequestContextProperties();
    private final WebClient client;
    private final OidcClientRegistrationConfig oidcConfig;
    private final String registrationClientUri;
    private final String registrationToken;
    private final ClientMetadata registeredMetadata;
    private final Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters;
    private final Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters;
    private volatile boolean closed;

    public RegisteredClientImpl(WebClient client, OidcClientRegistrationConfig oidcConfig, Map<OidcEndpoint.Type, List<OidcRequestFilter>> oidcRequestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> oidcResponseFilters, ClientMetadata registeredMetadata, String registrationClientUri, String registrationToken) {
        this.client = client;
        this.oidcConfig = oidcConfig;
        this.registrationClientUri = registrationClientUri;
        this.registrationToken = registrationToken;
        this.registeredMetadata = registeredMetadata;
        this.requestFilters = oidcRequestFilters;
        this.responseFilters = oidcResponseFilters;
    }

    @Override
    public ClientMetadata metadata() {
        this.checkClosed();
        return new ClientMetadata(this.registeredMetadata.getMetadataString());
    }

    @Override
    public Uni<RegisteredClient> read() {
        this.checkClosed();
        this.checkClientRequestUri();
        HttpRequest request = this.client.getAbs(this.registrationClientUri);
        request.putHeader(HttpHeaders.ACCEPT.toString(), APPLICATION_JSON);
        OidcRequestContextProperties requestProps = this.getRequestProps();
        return this.makeRequest(requestProps, (HttpRequest<Buffer>)request, Buffer.buffer()).transform(resp -> this.newRegisteredClient((HttpResponse<Buffer>)resp, requestProps));
    }

    @Override
    public Uni<RegisteredClient> update(ClientMetadata newMetadata) {
        this.checkClosed();
        this.checkClientRequestUri();
        if (newMetadata.getClientId() != null && !this.registeredMetadata.getClientId().equals(newMetadata.getClientId())) {
            throw new OidcClientRegistrationException("Client id can not be modified");
        }
        if (newMetadata.getClientSecret() != null && !this.registeredMetadata.getClientSecret().equals(newMetadata.getClientSecret())) {
            throw new OidcClientRegistrationException("Client secret can not be modified");
        }
        JsonObjectBuilder builder = JsonProviderHolder.jsonProvider().createObjectBuilder();
        JsonObject newJsonObject = newMetadata.getJsonObject();
        JsonObject currentJsonObject = this.registeredMetadata.getJsonObject();
        LOG.debugf("Current client metadata: %s", (Object)currentJsonObject.toString());
        for (Map.Entry entry : currentJsonObject.entrySet()) {
            if (PRIVATE_PROPERTIES.contains(entry.getKey())) continue;
            boolean newPropValue = newJsonObject.containsKey(entry.getKey());
            builder.add((String)entry.getKey(), newPropValue ? (JsonValue)newJsonObject.get(entry.getKey()) : (JsonValue)entry.getValue());
        }
        for (Map.Entry entry : newJsonObject.entrySet()) {
            if (PRIVATE_PROPERTIES.contains(entry.getKey()) || currentJsonObject.containsKey(entry.getKey())) continue;
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        JsonObject json = builder.build();
        LOG.debugf("Updated client metadata: %s", (Object)json.toString());
        HttpRequest request = this.client.putAbs(this.registrationClientUri);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), APPLICATION_JSON);
        request.putHeader(HttpHeaders.ACCEPT.toString(), APPLICATION_JSON);
        OidcRequestContextProperties requestProps = this.getRequestProps();
        return this.makeRequest(requestProps, (HttpRequest<Buffer>)request, Buffer.buffer((String)json.toString())).transform(resp -> this.newRegisteredClient((HttpResponse<Buffer>)resp, requestProps));
    }

    @Override
    public Uni<Void> delete() {
        this.checkClosed();
        this.checkClientRequestUri();
        OidcRequestContextProperties requestProps = this.getRequestProps();
        return this.makeRequest(requestProps, (HttpRequest<Buffer>)this.client.deleteAbs(this.registrationClientUri), Buffer.buffer()).transformToUni(resp -> this.deleteResponse((HttpResponse<Buffer>)resp, requestProps));
    }

    private OidcRequestContextProperties getRequestProps() {
        return this.requestFilters.isEmpty() ? DEFAULT_REQUEST_PROPS : new OidcRequestContextProperties();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.client.close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Failed to close the client", (Throwable)ex);
            }
            this.closed = true;
        }
    }

    private UniOnItem<HttpResponse<Buffer>> makeRequest(OidcRequestContextProperties requestProps, HttpRequest<Buffer> request, Buffer buffer) {
        if (this.registrationToken != null) {
            request.putHeader(AUTHORIZATION_HEADER, "Bearer " + this.registrationToken);
        }
        Uni response = this.filterHttpRequest(requestProps, request, buffer).sendBuffer(buffer).onFailure(SocketException.class).retry().atMost((long)this.oidcConfig.connectionRetryCount()).onFailure().transform(t -> {
            LOG.warn((Object)"OIDC Server is not available:", t.getCause() != null ? t.getCause() : t);
            return new OidcClientRegistrationException("OIDC Server is not available");
        });
        return response.onItem();
    }

    private HttpRequest<Buffer> filterHttpRequest(OidcRequestContextProperties requestProps, HttpRequest<Buffer> request, Buffer body) {
        if (!this.requestFilters.isEmpty()) {
            OidcRequestFilter.OidcRequestContext context = new OidcRequestFilter.OidcRequestContext(request, body, requestProps);
            for (OidcRequestFilter filter : OidcCommonUtils.getMatchingOidcRequestFilters(this.requestFilters, (OidcEndpoint.Type)OidcEndpoint.Type.REGISTERED_CLIENT)) {
                filter.filter(context);
            }
        }
        return request;
    }

    private RegisteredClient newRegisteredClient(HttpResponse<Buffer> resp, OidcRequestContextProperties requestProps) {
        Buffer buffer = (Buffer)resp.body();
        OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, (Buffer)buffer, this.responseFilters, (OidcEndpoint.Type)OidcEndpoint.Type.REGISTERED_CLIENT);
        if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
            io.vertx.core.json.JsonObject json = buffer.toJsonObject();
            LOG.debugf("Client metadata has been succesfully updated: %s", (Object)json.toString());
            String newRegistrationClientUri = (String)json.remove("registration_client_uri");
            String newRegistrationToken = (String)json.remove("registration_access_token");
            return new RegisteredClientImpl(this.client, this.oidcConfig, this.requestFilters, this.responseFilters, new ClientMetadata(json.toString()), newRegistrationClientUri != null ? newRegistrationClientUri : this.registrationClientUri, newRegistrationToken != null ? newRegistrationToken : this.registrationToken);
        }
        String errorMessage = buffer.toString();
        LOG.debugf("Client configuration update has failed:  status: %d, error message: %s", resp.statusCode(), (Object)errorMessage);
        throw new OidcClientRegistrationException(errorMessage);
    }

    private Uni<Void> deleteResponse(HttpResponse<Buffer> resp, OidcRequestContextProperties requestProps) {
        Buffer buffer = (Buffer)resp.body();
        OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, (Buffer)buffer, this.responseFilters, (OidcEndpoint.Type)OidcEndpoint.Type.REGISTERED_CLIENT);
        if (resp.statusCode() == 200) {
            LOG.debug((Object)"Client has been succesfully deleted");
            return Uni.createFrom().voidItem();
        }
        String errorMessage = buffer.toString();
        LOG.debugf("Client delete request has failed:  status: %d, error message: %s", resp.statusCode(), (Object)errorMessage);
        return Uni.createFrom().voidItem();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Registered OIDC Client is closed");
        }
    }

    private void checkClientRequestUri() {
        if (this.registrationClientUri == null) {
            throw new OidcClientRegistrationException("Registered OIDC Client can not make requests to the client configuration endpoint");
        }
    }

    @Override
    public String registrationUri() {
        return this.registrationClientUri;
    }

    @Override
    public String registrationToken() {
        return this.registrationToken;
    }
}

