/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.function.Supplier;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public class OidcClientImpl
implements OidcClient {
    private static final Logger LOG = Logger.getLogger(OidcClientImpl.class);
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String EXPIRES_AT = "expires_at";
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private final WebClient client;
    private final String tokenRequestUri;
    private final MultiMap tokenGrantParams;
    private final MultiMap commonRefreshGrantParams;
    private final String grantType;
    private final String clientSecretBasicAuthScheme;
    private final Key clientJwtKey;
    private final OidcClientConfig oidcConfig;

    public OidcClientImpl(WebClient client, String tokenRequestUri, String grantType, MultiMap tokenGrantParams, MultiMap commonRefreshGrantParams, OidcClientConfig oidcClientConfig) {
        this.client = client;
        this.tokenRequestUri = tokenRequestUri;
        this.tokenGrantParams = tokenGrantParams;
        this.commonRefreshGrantParams = commonRefreshGrantParams;
        this.grantType = grantType;
        this.oidcConfig = oidcClientConfig;
        this.clientSecretBasicAuthScheme = OidcClientImpl.initClientSecretBasicAuth(oidcClientConfig);
        this.clientJwtKey = OidcClientImpl.initClientJwtKey(oidcClientConfig);
    }

    private static String initClientSecretBasicAuth(OidcClientConfig oidcClientConfig) {
        if (OidcCommonUtils.isClientSecretBasicAuthRequired((OidcCommonConfig.Credentials)oidcClientConfig.credentials)) {
            return "Basic " + Base64.getEncoder().encodeToString(((String)oidcClientConfig.getClientId().get() + ":" + OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)oidcClientConfig.credentials)).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private static Key initClientJwtKey(OidcClientConfig oidcClientConfig) {
        if (OidcCommonUtils.isClientJwtAuthRequired((OidcCommonConfig.Credentials)oidcClientConfig.credentials)) {
            return OidcCommonUtils.clientJwtKey((OidcCommonConfig.Credentials)oidcClientConfig.credentials);
        }
        return null;
    }

    @Override
    public Uni<Tokens> getTokens() {
        return this.getJsonResponse(this.tokenGrantParams, false);
    }

    @Override
    public Uni<Tokens> refreshTokens(String refreshToken) {
        if (refreshToken == null) {
            throw new OidcClientException("Refresh token is null");
        }
        MultiMap refreshGrantParams = OidcClientImpl.copyMultiMap(this.commonRefreshGrantParams);
        refreshGrantParams.add(REFRESH_TOKEN, refreshToken);
        return this.getJsonResponse(refreshGrantParams, true);
    }

    private Uni<Tokens> getJsonResponse(final MultiMap reqBody, final boolean refresh) {
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends Tokens>>(){

            @Override
            public Uni<Tokens> get() {
                MultiMap body = reqBody;
                HttpRequest request = OidcClientImpl.this.client.postAbs(OidcClientImpl.this.tokenRequestUri);
                if (OidcClientImpl.this.clientSecretBasicAuthScheme != null) {
                    request.putHeader(AUTHORIZATION_HEADER, OidcClientImpl.this.clientSecretBasicAuthScheme);
                } else if (OidcClientImpl.this.clientJwtKey != null) {
                    body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
                    body.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                    body.add("client_assertion", OidcCommonUtils.signJwtWithKey((OidcCommonConfig)OidcClientImpl.this.oidcConfig, (Key)OidcClientImpl.this.clientJwtKey));
                }
                return request.sendForm(body).onItem().transform(resp -> OidcClientImpl.this.emitGrantTokens((HttpResponse<Buffer>)resp, refresh));
            }
        });
    }

    private Tokens emitGrantTokens(HttpResponse<Buffer> resp, boolean refresh) {
        if (resp.statusCode() == 200) {
            LOG.debugf("%s OidcClient has %s the tokens", (Object)this.oidcConfig.getId().get(), (Object)(refresh ? "refreshed" : "acquired"));
            JsonObject json = resp.bodyAsJsonObject();
            String accessToken = json.getString(ACCESS_TOKEN);
            String refreshToken = json.getString(REFRESH_TOKEN);
            Long accessTokenExpiresAt = json.getLong(EXPIRES_AT);
            if (accessTokenExpiresAt == null) {
                accessTokenExpiresAt = OidcClientImpl.getExpiresJwtClaim(accessToken);
            }
            return new Tokens(accessToken, accessTokenExpiresAt, refreshToken);
        }
        LOG.debugf("%s OidcClient has failed to complete the %s grant request: %s", (Object)this.oidcConfig.getId().get(), (Object)(refresh ? REFRESH_TOKEN : this.grantType), (Object)resp.bodyAsString());
        throw new OidcClientException();
    }

    private static Long getExpiresJwtClaim(String accessToken) {
        JsonObject claims = OidcClientImpl.decodeJwtToken(accessToken);
        if (claims != null) {
            try {
                return claims.getLong(Claims.exp.name());
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"JWT expiry claim can not be converted to Long");
            }
        }
        return null;
    }

    private static JsonObject decodeJwtToken(String accessToken) {
        String[] parts = accessToken.split("\\.");
        if (parts.length == 3) {
            try {
                return new JsonObject(new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"JWT token can not be decoded using the Base64Url encoding scheme");
            }
        } else {
            LOG.debug((Object)"Access token is not formatted as the encoded JWT token");
        }
        return null;
    }

    private static MultiMap copyMultiMap(MultiMap oldMap) {
        MultiMap newMap = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        newMap.addAll(oldMap);
        return newMap;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

