/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client;

public class Tokens {
    private final String accessToken;
    private final Long accessTokenExpiresAt;
    private final String refreshToken;

    public Tokens(String accessToken, Long accessTokenExpiresAt, String refreshToken) {
        this.accessToken = accessToken;
        this.accessTokenExpiresAt = accessTokenExpiresAt;
        this.refreshToken = refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getAccessTokenExpiresAt() {
        return this.accessTokenExpiresAt;
    }

    public boolean isAccessTokenExpired() {
        if (this.accessTokenExpiresAt == null) {
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        return now > this.accessTokenExpiresAt;
    }
}

