/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.TokensHelper;
import io.smallrye.mutiny.Uni;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public abstract class AbstractTokensProducer {
    @Inject
    OidcClient oidcClient;
    @Inject
    @ConfigProperty(name="quarkus.oidc-client.early-tokens-acquisition")
    boolean earlyTokenAcquisition;
    TokensHelper tokensHelper = new TokensHelper();

    @PostConstruct
    public void initTokens() {
        if (this.earlyTokenAcquisition) {
            this.tokensHelper.initTokens(this.oidcClient);
        }
    }

    public Uni<Tokens> getTokens() {
        return this.tokensHelper.getTokens(this.oidcClient);
    }
}

