/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.TokensHelper;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public abstract class AbstractTokensProducer {
    private OidcClient oidcClient;
    @Inject
    @ConfigProperty(name="quarkus.oidc-client.early-tokens-acquisition")
    public boolean earlyTokenAcquisition;
    final TokensHelper tokensHelper = new TokensHelper();

    @PostConstruct
    public void init() {
        OidcClients oidcClients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
        Optional<String> clientId = Objects.requireNonNull(this.clientId(), "clientId must not be null");
        this.oidcClient = clientId.isPresent() ? Objects.requireNonNull(oidcClients.getClient(clientId.get()), "Unknown client") : oidcClients.getClient();
        this.initTokens();
    }

    protected void initTokens() {
        if (this.earlyTokenAcquisition) {
            this.tokensHelper.initTokens(this.oidcClient);
        }
    }

    public Uni<Tokens> getTokens() {
        return this.tokensHelper.getTokens(this.oidcClient);
    }

    public Tokens awaitTokens() {
        return (Tokens)this.getTokens().await().indefinitely();
    }

    protected Optional<String> clientId() {
        return Optional.empty();
    }
}

