/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client;

import io.quarkus.oidc.client.runtime.OidcClientConfig;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfigBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class OidcClientConfigBuilder
extends OidcClientCommonConfigBuilder<OidcClientConfigBuilder> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean earlyTokensAcquisition;
    private final Map<String, Map<String, String>> grantOptions = new HashMap<String, Map<String, String>>();
    private final List<String> scopes = new ArrayList<String>();
    private OidcClientConfig.Grant grant;
    private boolean absoluteExpiresIn;
    private Optional<Duration> accessTokenExpiresIn;
    private Optional<Duration> refreshTokenTimeSkew;
    private boolean clientEnabled;
    private Optional<String> id;

    public OidcClientConfigBuilder(OidcClientConfig config) {
        super((OidcClientCommonConfig)Objects.requireNonNull(config));
        this.headers.putAll(config.headers());
        this.earlyTokensAcquisition = config.earlyTokensAcquisition();
        this.grantOptions.putAll(config.grantOptions());
        this.grant = config.grant();
        this.absoluteExpiresIn = config.absoluteExpiresIn();
        this.accessTokenExpiresIn = config.accessTokenExpiresIn();
        this.refreshTokenTimeSkew = config.refreshTokenTimeSkew();
        this.clientEnabled = config.clientEnabled();
        this.id = config.id();
        if (config.scopes().isPresent()) {
            this.scopes.addAll((Collection<String>)config.scopes().get());
        }
    }

    protected OidcClientConfigBuilder getBuilder() {
        return this;
    }

    public OidcClientConfigBuilder headers(String headerName, String headerValue) {
        Objects.requireNonNull(headerName);
        Objects.requireNonNull(headerValue);
        this.headers.put(headerName, headerValue);
        return this;
    }

    public OidcClientConfigBuilder headers(Map<String, String> headers) {
        Objects.requireNonNull(headers);
        this.headers.putAll(headers);
        return this;
    }

    public OidcClientConfigBuilder earlyTokensAcquisition(boolean earlyTokensAcquisition) {
        this.earlyTokensAcquisition = earlyTokensAcquisition;
        return this;
    }

    public OidcClientConfigBuilder grantOptions(String grantName, Map<String, String> options) {
        Objects.requireNonNull(grantName);
        Objects.requireNonNull(options);
        this.grantOptions.computeIfAbsent(grantName, k -> new HashMap()).putAll(options);
        return this;
    }

    public OidcClientConfigBuilder grantOptions(String grantName, String key, String value) {
        Objects.requireNonNull(grantName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.grantOptions.computeIfAbsent(grantName, k -> new HashMap()).put(key, value);
        return this;
    }

    public OidcClientConfigBuilder grantOptions(Map<String, Map<String, String>> grantOptions) {
        Objects.requireNonNull(grantOptions);
        this.grantOptions.putAll(grantOptions);
        return this;
    }

    public OidcClientConfigBuilder absoluteExpiresIn(boolean absoluteExpiresIn) {
        this.absoluteExpiresIn = absoluteExpiresIn;
        return this;
    }

    public OidcClientConfigBuilder accessTokenExpiresIn(Duration accessTokenExpiresIn) {
        this.accessTokenExpiresIn = Optional.ofNullable(accessTokenExpiresIn);
        return this;
    }

    public OidcClientConfigBuilder refreshTokenTimeSkew(Duration refreshTokenTimeSkew) {
        this.refreshTokenTimeSkew = Optional.ofNullable(refreshTokenTimeSkew);
        return this;
    }

    public OidcClientConfigBuilder scopes(List<String> scopes) {
        Objects.requireNonNull(scopes);
        this.scopes.addAll(scopes);
        return this;
    }

    public OidcClientConfigBuilder scopes(String ... scopes) {
        Objects.requireNonNull(scopes);
        this.scopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public OidcClientConfigBuilder clientEnabled(boolean clientEnabled) {
        this.clientEnabled = clientEnabled;
        return this;
    }

    public OidcClientConfigBuilder id(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public OidcClientConfigBuilder grant(OidcClientConfig.Grant grant) {
        this.grant = Objects.requireNonNull(grant);
        return this;
    }

    public OidcClientConfigBuilder grant(OidcClientConfig.Grant.Type type) {
        return this.grant().type(type).end();
    }

    public GrantBuilder grant() {
        return new GrantBuilder(this);
    }

    public OidcClientConfig build() {
        if (this.id.isEmpty()) {
            throw new IllegalArgumentException("Client ID cannot be empty");
        }
        return new OidcClientConfigImpl(this);
    }

    public static final class GrantBuilder {
        private final OidcClientConfigBuilder builder;
        private OidcClientConfig.Grant.Type type;
        private String accessTokenProperty;
        private String refreshTokenProperty;
        private String expiresInProperty;
        private String refreshExpiresInProperty;

        public GrantBuilder() {
            this(OidcClientConfig.builder());
        }

        public GrantBuilder(OidcClientConfigBuilder builder) {
            this.builder = builder;
            this.type = builder.grant.type();
            this.accessTokenProperty = builder.grant.accessTokenProperty();
            this.refreshTokenProperty = builder.grant.refreshTokenProperty();
            this.expiresInProperty = builder.grant.expiresInProperty();
            this.refreshExpiresInProperty = builder.grant.refreshExpiresInProperty();
        }

        public GrantBuilder type(OidcClientConfig.Grant.Type type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public GrantBuilder refreshTokenProperty(String refreshTokenProperty) {
            this.refreshTokenProperty = Objects.requireNonNull(refreshTokenProperty);
            return this;
        }

        public GrantBuilder expiresInProperty(String expiresInProperty) {
            this.expiresInProperty = Objects.requireNonNull(expiresInProperty);
            return this;
        }

        public GrantBuilder refreshExpiresInProperty(String refreshExpiresInProperty) {
            this.refreshExpiresInProperty = Objects.requireNonNull(refreshExpiresInProperty);
            return this;
        }

        public GrantBuilder accessTokenProperty(String accessTokenProperty) {
            this.accessTokenProperty = Objects.requireNonNull(accessTokenProperty);
            return this;
        }

        public OidcClientConfigBuilder end() {
            Objects.requireNonNull(this.builder);
            return this.builder.grant(this.build());
        }

        public OidcClientConfig.Grant build() {
            return new GrantImpl(this.type, this.accessTokenProperty, this.refreshTokenProperty, this.expiresInProperty, this.refreshExpiresInProperty);
        }

        private record GrantImpl(OidcClientConfig.Grant.Type type, String accessTokenProperty, String refreshTokenProperty, String expiresInProperty, String refreshExpiresInProperty) implements OidcClientConfig.Grant
        {
        }
    }

    private static class OidcClientConfigImpl
    extends OidcClientCommonConfigBuilder.OidcClientCommonConfigImpl
    implements OidcClientConfig {
        private final Map<String, String> headers;
        private final boolean earlyTokensAcquisition;
        private final Map<String, Map<String, String>> grantOptions;
        private final OidcClientConfig.Grant grant;
        private final boolean absoluteExpiresIn;
        private final Optional<Duration> accessTokenExpiresIn;
        private final Optional<Duration> refreshTokenTimeSkew;
        private final Optional<List<String>> scopes;
        private final boolean clientEnabled;
        private final Optional<String> id;

        private OidcClientConfigImpl(OidcClientConfigBuilder builder) {
            super((OidcClientCommonConfigBuilder)builder);
            this.headers = Map.copyOf(builder.headers);
            this.earlyTokensAcquisition = builder.earlyTokensAcquisition;
            this.grantOptions = Map.copyOf(builder.grantOptions);
            this.grant = builder.grant;
            this.absoluteExpiresIn = builder.absoluteExpiresIn;
            this.accessTokenExpiresIn = builder.accessTokenExpiresIn;
            this.refreshTokenTimeSkew = builder.refreshTokenTimeSkew;
            this.scopes = builder.scopes.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(builder.scopes));
            this.clientEnabled = builder.clientEnabled;
            this.id = builder.id;
        }

        @Override
        public Optional<String> id() {
            return this.id;
        }

        @Override
        public boolean clientEnabled() {
            return this.clientEnabled;
        }

        @Override
        public Optional<List<String>> scopes() {
            return this.scopes;
        }

        @Override
        public Optional<Duration> refreshTokenTimeSkew() {
            return this.refreshTokenTimeSkew;
        }

        @Override
        public Optional<Duration> accessTokenExpiresIn() {
            return this.accessTokenExpiresIn;
        }

        @Override
        public boolean absoluteExpiresIn() {
            return this.absoluteExpiresIn;
        }

        @Override
        public OidcClientConfig.Grant grant() {
            return this.grant;
        }

        @Override
        public Map<String, Map<String, String>> grantOptions() {
            return this.grantOptions;
        }

        @Override
        public boolean earlyTokensAcquisition() {
            return this.earlyTokensAcquisition;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }
    }
}

