/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Optional;
import javax.crypto.SecretKey;

public class OidcCommonUtils {
    private OidcCommonUtils() {
    }

    public static void verifyCommonConfiguration(OidcCommonConfig oidcConfig) {
        if (!oidcConfig.getAuthServerUrl().isPresent() || !oidcConfig.getClientId().isPresent()) {
            throw new ConfigurationException("Both 'auth-server-url' and 'client-id' properties must be configured");
        }
        OidcCommonConfig.Credentials creds = oidcConfig.getCredentials();
        if (creds.secret.isPresent() && creds.clientSecret.value.isPresent()) {
            throw new ConfigurationException("'credentials.secret' and 'credentials.client-secret' properties are mutually exclusive");
        }
        if ((creds.secret.isPresent() || creds.clientSecret.value.isPresent()) && creds.jwt.secret.isPresent()) {
            throw new ConfigurationException("Use only 'credentials.secret' or 'credentials.client-secret' or 'credentials.jwt.secret' property");
        }
    }

    public static String prependSlash(String path) {
        return !path.startsWith("/") ? "/" + path : path;
    }

    public static void setHttpClientOptions(OidcCommonConfig oidcConfig, TlsConfig tlsConfig, HttpClientOptions options) {
        Optional<ProxyOptions> proxyOpt;
        boolean trustAll;
        boolean bl = oidcConfig.tls.verification.isPresent() ? oidcConfig.tls.verification.get() == OidcCommonConfig.Tls.Verification.NONE : (trustAll = tlsConfig.trustAll);
        if (trustAll) {
            options.setTrustAll(true);
            options.setVerifyHost(false);
        }
        if ((proxyOpt = OidcCommonUtils.toProxyOptions(oidcConfig.getProxy())).isPresent()) {
            options.setProxyOptions(proxyOpt.get());
        }
        options.setConnectTimeout((int)oidcConfig.getConnectionTimeout().toMillis());
    }

    public static String getAuthServerUrl(OidcCommonConfig oidcConfig) {
        String authServerUrl = oidcConfig.getAuthServerUrl().get();
        if (authServerUrl.endsWith("/")) {
            authServerUrl = authServerUrl.substring(0, authServerUrl.length() - 1);
        }
        return authServerUrl;
    }

    public static String getOidcEndpointUrl(String authServerUrl, Optional<String> endpointPath) {
        if (endpointPath.isPresent()) {
            return authServerUrl + OidcCommonUtils.prependSlash(endpointPath.get());
        }
        return null;
    }

    public static long getConnectionRetryCount(OidcCommonConfig oidcConfig) {
        long connectionDelayInSecs = OidcCommonUtils.getConnectionDelay(oidcConfig);
        return connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
    }

    public static long getMaximumConnectionDelay(OidcCommonConfig oidcConfig) {
        long connectionDelayInSecs = OidcCommonUtils.getConnectionDelay(oidcConfig);
        long connectionRetryCountSecs = connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
        return connectionDelayInSecs + connectionRetryCountSecs * oidcConfig.getConnectionTimeout().getSeconds();
    }

    private static long getConnectionDelay(OidcCommonConfig oidcConfig) {
        return oidcConfig.getConnectionDelay().isPresent() ? oidcConfig.getConnectionDelay().get().getSeconds() : 0L;
    }

    public static long getConnectionDelayInMillis(OidcCommonConfig oidcConfig) {
        return OidcCommonUtils.getConnectionDelay(oidcConfig) * 1000L;
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy proxyConfig) {
        if (!proxyConfig.host.isPresent()) {
            return Optional.empty();
        }
        JsonObject jsonOptions = new JsonObject();
        jsonOptions.put("host", proxyConfig.host.get());
        jsonOptions.put("port", Integer.valueOf(proxyConfig.port));
        if (proxyConfig.username.isPresent()) {
            jsonOptions.put("username", proxyConfig.username.get());
        }
        if (proxyConfig.password.isPresent()) {
            jsonOptions.put("password", proxyConfig.password.get());
        }
        return Optional.of(new ProxyOptions(jsonOptions));
    }

    public static String formatConnectionErrorMessage(String authServerUrlString) {
        return String.format("OIDC server is not available at the '%s' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'", authServerUrlString);
    }

    public static boolean isClientSecretBasicAuthRequired(OidcCommonConfig.Credentials creds) {
        return creds.secret.isPresent() || creds.clientSecret.value.isPresent() && creds.clientSecret.method.orElseGet(() -> OidcCommonConfig.Credentials.Secret.Method.BASIC) == OidcCommonConfig.Credentials.Secret.Method.BASIC;
    }

    public static boolean isClientJwtAuthRequired(OidcCommonConfig.Credentials creds) {
        return creds.jwt.secret.isPresent() || creds.jwt.keyFile.isPresent() || creds.jwt.keyStoreFile.isPresent();
    }

    public static boolean isClientSecretPostAuthRequired(OidcCommonConfig.Credentials creds) {
        return creds.clientSecret.value.isPresent() && creds.clientSecret.method.orElseGet(() -> OidcCommonConfig.Credentials.Secret.Method.BASIC) == OidcCommonConfig.Credentials.Secret.Method.POST;
    }

    public static String clientSecret(OidcCommonConfig.Credentials creds) {
        return creds.secret.orElseGet(() -> creds.clientSecret.value.get());
    }

    public static Key clientJwtKey(OidcCommonConfig.Credentials creds) {
        if (creds.jwt.secret.isPresent()) {
            return KeyUtils.createSecretKeyFromSecret((String)creds.jwt.secret.get());
        }
        Key key = null;
        try {
            if (creds.jwt.keyFile.isPresent()) {
                key = KeyUtils.readSigningKey((String)creds.jwt.keyFile.get(), (String)creds.jwt.keyId.orElse(null));
            } else if (creds.jwt.keyStoreFile.isPresent()) {
                KeyStore ks = KeyStore.getInstance("JKS");
                InputStream is = ResourceUtils.getResourceStream((String)creds.jwt.keyStoreFile.get());
                ks.load(is, creds.jwt.keyStorePassword.toCharArray());
                key = ks.getKey(creds.jwt.keyId.get(), creds.jwt.keyPassword.toCharArray());
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException("Key can not be loaded");
        }
        if (key == null) {
            throw new ConfigurationException("Key is null");
        }
        return key;
    }

    public static String signJwt(OidcCommonConfig oidcConfig) {
        return OidcCommonUtils.signJwtWithKey(oidcConfig, OidcCommonUtils.clientJwtKey(oidcConfig.credentials));
    }

    public static String signJwtWithKey(OidcCommonConfig oidcConfig, Key key) {
        JwtClaimsBuilder builder = Jwt.issuer((String)oidcConfig.clientId.get()).subject(oidcConfig.clientId.get()).audience(OidcCommonUtils.getAuthServerUrl(oidcConfig)).expiresIn((long)oidcConfig.credentials.jwt.lifespan);
        if (key instanceof SecretKey) {
            return builder.sign((SecretKey)key);
        }
        return builder.sign((PrivateKey)key);
    }

    public static void verifyConfigurationId(String defaultId, String configKey, Optional<String> configId) {
        if (configKey.equals(defaultId)) {
            throw new ConfigurationException("configuration id '" + configKey + "' duplicates the default configuration id");
        }
        if (configId.isPresent() && !configKey.equals(configId.get())) {
            throw new ConfigurationException("Configuration has 2 different id values: '" + configKey + "' and '" + configId.get() + "'");
        }
    }
}

