/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJsonObject {
    private String jsonString;
    private JsonObject json;

    protected AbstractJsonObject() {
        this.json = Json.createObjectBuilder().build();
    }

    protected AbstractJsonObject(String jsonString) {
        this(AbstractJsonObject.toJsonObject(jsonString));
        this.jsonString = jsonString;
    }

    protected AbstractJsonObject(JsonObject json) {
        this.json = json;
    }

    public String getString(String name) {
        return this.contains(name) ? this.json.getString(name) : null;
    }

    public Boolean getBoolean(String name) {
        return this.contains(name) ? Boolean.valueOf(this.json.getBoolean(name)) : null;
    }

    public Long getLong(String name) {
        JsonNumber number = this.contains(name) ? this.json.getJsonNumber(name) : null;
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    public JsonArray getArray(String name) {
        return this.contains(name) ? this.json.getJsonArray(name) : null;
    }

    public JsonObject getObject(String name) {
        return this.contains(name) ? this.json.getJsonObject(name) : null;
    }

    public JsonObject getJsonObject() {
        return Json.createObjectBuilder((JsonObject)this.json).build();
    }

    public Object get(String name) {
        return this.json.get((Object)name);
    }

    public boolean contains(String propertyName) {
        return this.json != null && this.json.containsKey((Object)propertyName) && !this.json.isNull(propertyName);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.json.keySet());
    }

    public Set<Map.Entry<String, JsonValue>> getAllProperties() {
        return Collections.unmodifiableSet(this.json.entrySet());
    }

    protected String getJsonString() {
        return this.jsonString == null ? this.json.toString() : this.jsonString;
    }

    protected List<String> getListOfStrings(String prop) {
        JsonArray array = this.getArray(prop);
        if (array == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonValue value : array) {
            list.add(((JsonString)value).getString());
        }
        return list;
    }

    public static JsonObject toJsonObject(String json) {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

