/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OidcClientCommonConfig
extends OidcCommonConfig {
    public Optional<String> tokenPath = Optional.empty();
    public Optional<String> revokePath = Optional.empty();
    public Optional<String> clientId = Optional.empty();
    public Optional<String> clientName = Optional.empty();
    public Credentials credentials = new Credentials();

    public OidcClientCommonConfig() {
    }

    protected OidcClientCommonConfig(io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig mapping) {
        super(mapping);
        this.tokenPath = mapping.tokenPath();
        this.revokePath = mapping.revokePath();
        this.clientId = mapping.clientId();
        this.clientName = mapping.clientName();
        this.credentials.addConfigMappingValues(mapping.credentials());
    }

    public Optional<String> getTokenPath() {
        return this.tokenPath;
    }

    public void setTokenPath(String tokenPath) {
        this.tokenPath = Optional.of(tokenPath);
    }

    public Optional<String> getRevokePath() {
        return this.revokePath;
    }

    public void setRevokePath(String revokePath) {
        this.revokePath = Optional.of(revokePath);
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = Optional.of(clientId);
    }

    public Optional<String> getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = Optional.of(clientName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public static class Credentials {
        public Optional<String> secret = Optional.empty();
        public Secret clientSecret = new Secret();
        public Jwt jwt = new Jwt();

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public Secret getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(Secret clientSecret) {
            this.clientSecret = clientSecret;
        }

        public Jwt getJwt() {
            return this.jwt;
        }

        public void setJwt(Jwt jwt) {
            this.jwt = jwt;
        }

        private void addConfigMappingValues(OidcClientCommonConfig.Credentials mapping) {
            this.secret = mapping.secret();
            this.clientSecret.addConfigMappingValues(mapping.clientSecret());
            this.jwt.addConfigMappingValues(mapping.jwt());
        }

        public static class Secret {
            public Optional<String> value = Optional.empty();
            public Provider provider = new Provider();
            public Optional<Method> method = Optional.empty();

            public Optional<String> getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = Optional.of(value);
            }

            public Optional<Method> getMethod() {
                return this.method;
            }

            public void setMethod(Method method) {
                this.method = Optional.of(method);
            }

            public Provider getSecretProvider() {
                return this.provider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.provider = secretProvider;
            }

            private void addConfigMappingValues(OidcClientCommonConfig.Credentials.Secret mapping) {
                this.value = mapping.value();
                this.provider.addConfigMappingValues(mapping.provider());
                this.method = mapping.method().map(Enum::toString).map(Method::valueOf);
            }

            public static enum Method {
                BASIC,
                POST,
                POST_JWT,
                QUERY;

            }
        }

        public static class Jwt {
            public Source source = Source.CLIENT;
            public Optional<String> secret = Optional.empty();
            public Provider secretProvider = new Provider();
            public Optional<String> key = Optional.empty();
            public Optional<String> keyFile = Optional.empty();
            public Optional<String> keyStoreFile = Optional.empty();
            public Optional<String> keyStorePassword;
            public Optional<String> keyId = Optional.empty();
            public Optional<String> keyPassword;
            public Optional<String> audience = Optional.empty();
            public Optional<String> tokenKeyId = Optional.empty();
            public Optional<String> issuer = Optional.empty();
            public Optional<String> subject = Optional.empty();
            public Map<String, String> claims = new HashMap<String, String>();
            public Optional<String> signatureAlgorithm = Optional.empty();
            public int lifespan = 10;
            public boolean assertion = false;

            public Optional<String> getSecret() {
                return this.secret;
            }

            public void setSecret(String secret) {
                this.secret = Optional.of(secret);
            }

            public int getLifespan() {
                return this.lifespan;
            }

            public void setLifespan(int lifespan) {
                this.lifespan = lifespan;
            }

            public Optional<String> getTokenKeyId() {
                return this.tokenKeyId;
            }

            public void setTokenKeyId(String tokenKeyId) {
                this.tokenKeyId = Optional.of(tokenKeyId);
            }

            public Provider getSecretProvider() {
                return this.secretProvider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.secretProvider = secretProvider;
            }

            public Optional<String> getSignatureAlgorithm() {
                return this.signatureAlgorithm;
            }

            public void setSignatureAlgorithm(String signatureAlgorithm) {
                this.signatureAlgorithm = Optional.of(signatureAlgorithm);
            }

            public Optional<String> getAudience() {
                return this.audience;
            }

            public void setAudience(String audience) {
                this.audience = Optional.of(audience);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }

            public Optional<String> getKeyFile() {
                return this.keyFile;
            }

            public void setKeyFile(String keyFile) {
                this.keyFile = Optional.of(keyFile);
            }

            public Map<String, String> getClaims() {
                return this.claims;
            }

            public void setClaims(Map<String, String> claims) {
                this.claims = claims;
            }

            public Source getSource() {
                return this.source;
            }

            public void setSource(Source source) {
                this.source = source;
            }

            public boolean isAssertion() {
                return this.assertion;
            }

            public void setAssertion(boolean assertion) {
                this.assertion = assertion;
            }

            private void addConfigMappingValues(OidcClientCommonConfig.Credentials.Jwt mapping) {
                this.source = Source.valueOf(mapping.source().toString());
                this.secret = mapping.secret();
                this.secretProvider.addConfigMappingValues(mapping.secretProvider());
                this.key = mapping.key();
                this.keyFile = mapping.keyFile();
                this.keyStoreFile = mapping.keyStoreFile();
                this.keyStorePassword = mapping.keyStorePassword();
                this.keyId = mapping.keyId();
                this.keyPassword = mapping.keyPassword();
                this.audience = mapping.audience();
                this.tokenKeyId = mapping.tokenKeyId();
                this.issuer = mapping.issuer();
                this.subject = mapping.subject();
                this.claims = mapping.claims();
                this.signatureAlgorithm = mapping.signatureAlgorithm();
                this.lifespan = mapping.lifespan();
                this.assertion = mapping.assertion();
            }

            public static enum Source {
                CLIENT,
                BEARER;

            }
        }

        public static class Provider {
            public Optional<String> name = Optional.empty();
            public Optional<String> keyringName = Optional.empty();
            public Optional<String> key = Optional.empty();

            public Optional<String> getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = Optional.of(name);
            }

            public Optional<String> getKeyringName() {
                return this.keyringName;
            }

            public void setKeyringName(String keyringName) {
                this.keyringName = Optional.of(keyringName);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }

            private void addConfigMappingValues(OidcClientCommonConfig.Credentials.Provider mapping) {
                this.name = mapping.name();
                this.keyringName = mapping.keyringName();
                this.key = mapping.key();
            }
        }
    }
}

