/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public final class ClientAssertionProvider
implements Closeable {
    private static final Logger LOG = Logger.getLogger(ClientAssertionProvider.class);
    private final Vertx vertx;
    private final Path bearerTokenPath;
    private volatile ClientAssertion clientAssertion;

    public ClientAssertionProvider(Vertx vertx, Path bearerTokenPath) {
        this.vertx = vertx;
        this.bearerTokenPath = bearerTokenPath;
        this.clientAssertion = this.loadFromFileSystem();
    }

    public String getClientAssertion() {
        ClientAssertion clientAssertion = this.clientAssertion;
        if (ClientAssertionProvider.isInvalid(clientAssertion)) {
            clientAssertion = this.loadClientAssertion();
        }
        return clientAssertion == null ? null : clientAssertion.bearerToken;
    }

    @Override
    public void close() {
        this.cancelRefresh();
        this.clientAssertion = null;
    }

    private synchronized ClientAssertion loadClientAssertion() {
        if (ClientAssertionProvider.isInvalid(this.clientAssertion)) {
            this.cancelRefresh();
            this.clientAssertion = this.loadFromFileSystem();
        }
        return this.clientAssertion;
    }

    private long scheduleRefresh(long expiresAt) {
        long delay = (long)((double)expiresAt * 0.85);
        return this.vertx.setTimer(delay, (Handler)new Handler<Long>(){

            public void handle(Long ignored) {
                ClientAssertionProvider.this.clientAssertion = ClientAssertionProvider.this.loadFromFileSystem();
            }
        });
    }

    private void cancelRefresh() {
        if (this.clientAssertion != null) {
            this.vertx.cancelTimer(this.clientAssertion.timerId);
        }
    }

    private ClientAssertion loadFromFileSystem() {
        if (Files.exists(this.bearerTokenPath, new LinkOption[0])) {
            try {
                String bearerToken = Files.readString(this.bearerTokenPath).trim();
                Long expiresAt = ClientAssertionProvider.getExpiresAtFromExpClaim(bearerToken);
                if (expiresAt != null) {
                    return new ClientAssertion(bearerToken, expiresAt, this.scheduleRefresh(expiresAt));
                }
                LOG.error((Object)"Bearer token or its expiry claim is invalid");
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to read file with a bearer token at path: " + this.bearerTokenPath), (Throwable)e);
            }
        } else {
            LOG.warn((Object)("Cannot find a file with a bearer token at path: " + this.bearerTokenPath));
        }
        return null;
    }

    private static boolean isInvalid(ClientAssertion clientAssertion) {
        return clientAssertion == null || clientAssertion.isInvalid();
    }

    private static Long getExpiresAtFromExpClaim(String bearerToken) {
        JsonObject claims = OidcCommonUtils.decodeJwtContent(bearerToken);
        if (claims == null || !claims.containsKey(Claims.exp.name())) {
            return null;
        }
        try {
            return claims.getLong(Claims.exp.name());
        }
        catch (IllegalArgumentException ex) {
            LOG.debug((Object)"Bearer token expiry claim can not be converted to Long");
            return null;
        }
    }

    private record ClientAssertion(String bearerToken, long expiresAt, long timerId) {
        private boolean isInvalid() {
            long nowSecs = System.currentTimeMillis() / 1000L;
            return nowSecs > this.expiresAt;
        }
    }
}

