/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.db.token.state.manager;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.db.token.state.manager.OidcDbTokenStateManagerBuildTimeConfig;
import io.quarkus.oidc.db.token.state.manager.runtime.OidcDbTokenStateManager;
import io.quarkus.oidc.db.token.state.manager.runtime.OidcDbTokenStateManagerInitializer;
import io.quarkus.oidc.db.token.state.manager.runtime.OidcDbTokenStateManagerRecorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Singleton;
import java.util.function.BooleanSupplier;

@BuildSteps(onlyIf={OidcDbTokenStateManagerEnabled.class})
public class OidcDbTokenStateManagerProcessor {
    private static final String[] SUPPORTED_REACTIVE_CLIENTS = new String[]{"io.quarkus.reactive-pg-client", "io.quarkus.reactive-mysql-client", "io.quarkus.reactive-mssql-client", "io.quarkus.reactive-db2-client", "io.quarkus.reactive-oracle-client"};

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    SyntheticBeanBuildItem produceDbTokenStateManagerBean(OidcDbTokenStateManagerRecorder recorder, ReactiveSqlClientBuildItem sqlClientBuildItem) {
        String[] queryParamPlaceholders;
        switch (sqlClientBuildItem.reactiveClient) {
            case "io.quarkus.reactive-pg-client": {
                queryParamPlaceholders = new String[]{"$1", "$2", "$3", "$4", "$5"};
                break;
            }
            case "io.quarkus.reactive-mssql-client": {
                queryParamPlaceholders = new String[]{"@p1", "@p2", "@p3", "@p4", "@p5"};
                break;
            }
            case "io.quarkus.reactive-mysql-client": 
            case "io.quarkus.reactive-db2-client": 
            case "io.quarkus.reactive-oracle-client": {
                queryParamPlaceholders = new String[]{"?", "?", "?", "?", "?"};
                break;
            }
            default: {
                throw new RuntimeException("Unknown Reactive Sql Client " + sqlClientBuildItem.reactiveClient);
            }
        }
        String deleteStatement = String.format("DELETE FROM oidc_db_token_state_manager WHERE id = %s", queryParamPlaceholders[0]);
        String getQuery = String.format("SELECT id_token, access_token, refresh_token FROM oidc_db_token_state_manager WHERE id = %s", queryParamPlaceholders[0]);
        String insertStatement = String.format("INSERT INTO oidc_db_token_state_manager (id_token, access_token, refresh_token, expires_in, id) VALUES (%s, %s, %s, %s, %s)", queryParamPlaceholders[0], queryParamPlaceholders[1], queryParamPlaceholders[2], queryParamPlaceholders[3], queryParamPlaceholders[4]);
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcDbTokenStateManager.class).alternative(true)).priority(1)).addType(TokenStateManager.class)).unremovable()).scope(Singleton.class)).supplier(recorder.createTokenStateManager(insertStatement, deleteStatement, getQuery)).done();
    }

    @BuildStep
    ReactiveSqlClientBuildItem validateReactiveSqlClient(BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, Capabilities capabilities) {
        ReactiveSqlClientBuildItem sqlClientDbTable = null;
        for (String reactiveClient : SUPPORTED_REACTIVE_CLIENTS) {
            if (!capabilities.isPresent(reactiveClient)) continue;
            if (sqlClientDbTable == null) {
                sqlClientDbTable = new ReactiveSqlClientBuildItem(reactiveClient);
                continue;
            }
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException("The OpenID Connect Database Token State Manager extension is only supported when exactly one Reactive SQL Client extension is present.")}));
            return null;
        }
        if (sqlClientDbTable == null) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException("The OpenID Connect Database Token State Manager extension requires Reactive SQL Client extension. Please refer to the https://quarkus.io/guides/reactive-sql-clients for more information.")}));
        }
        return sqlClientDbTable;
    }

    @BuildStep
    AdditionalBeanBuildItem makeDbTokenStateManagerInitializerBean() {
        return new AdditionalBeanBuildItem(new Class[]{OidcDbTokenStateManagerInitializer.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem createDbTokenStateInitializerProps(ReactiveSqlClientBuildItem sqlClientBuildItem, OidcDbTokenStateManagerRecorder recorder) {
        boolean supportsIfTableNotExists;
        String createTableDdl;
        switch (sqlClientBuildItem.reactiveClient) {
            case "io.quarkus.reactive-pg-client": {
                createTableDdl = "CREATE TABLE IF NOT EXISTS oidc_db_token_state_manager (id VARCHAR(100) PRIMARY KEY, id_token VARCHAR, access_token VARCHAR, refresh_token VARCHAR, expires_in BIGINT NOT NULL)";
                supportsIfTableNotExists = true;
                break;
            }
            case "io.quarkus.reactive-mysql-client": {
                createTableDdl = "CREATE TABLE IF NOT EXISTS oidc_db_token_state_manager (id VARCHAR(100), id_token VARCHAR(5000) NULL, access_token VARCHAR(5000) NULL, refresh_token VARCHAR(5000) NULL, expires_in BIGINT NOT NULL, PRIMARY KEY (id))";
                supportsIfTableNotExists = true;
                break;
            }
            case "io.quarkus.reactive-mssql-client": {
                createTableDdl = "CREATE TABLE oidc_db_token_state_manager (id NVARCHAR(100) PRIMARY KEY, id_token NVARCHAR(MAX), access_token NVARCHAR(MAX), refresh_token NVARCHAR(MAX), expires_in BIGINT NOT NULL)";
                supportsIfTableNotExists = false;
                break;
            }
            case "io.quarkus.reactive-db2-client": {
                createTableDdl = "CREATE TABLE oidc_db_token_state_manager (id VARCHAR(100) NOT NULL PRIMARY KEY, id_token VARCHAR(4000), access_token VARCHAR(4000), refresh_token VARCHAR(4000), expires_in BIGINT NOT NULL)";
                supportsIfTableNotExists = false;
                break;
            }
            case "io.quarkus.reactive-oracle-client": {
                createTableDdl = "CREATE TABLE IF NOT EXISTS oidc_db_token_state_manager (id VARCHAR2(100), id_token VARCHAR2(4000), access_token VARCHAR2(4000), refresh_token VARCHAR2(4000), expires_in NUMBER NOT NULL, PRIMARY KEY (id))";
                supportsIfTableNotExists = true;
                break;
            }
            default: {
                throw new ConfigurationException("Unknown Reactive Sql Client " + sqlClientBuildItem.reactiveClient);
            }
        }
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcDbTokenStateManagerInitializer.OidcDbTokenStateManagerInitializerProperties.class).supplier(recorder.createDbTokenStateInitializerProps(createTableDdl, supportsIfTableNotExists)).unremovable()).scope(Dependent.class)).done();
    }

    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void setSqlClientPool(OidcDbTokenStateManagerRecorder recorder, BeanContainerBuildItem beanContainer) {
        recorder.setSqlClientPool(beanContainer.getValue());
    }

    static final class ReactiveSqlClientBuildItem
    extends SimpleBuildItem {
        private final String reactiveClient;

        private ReactiveSqlClientBuildItem(String reactiveClient) {
            this.reactiveClient = reactiveClient;
        }
    }

    static final class OidcDbTokenStateManagerEnabled
    implements BooleanSupplier {
        OidcDbTokenStateManagerBuildTimeConfig config;

        OidcDbTokenStateManagerEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled();
        }
    }
}

