/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.time.Duration;
import java.util.Map;
import org.jboss.logging.Logger;

public class OidcPasswordClientCredHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(OidcPasswordClientCredHandler.class);
    Map<String, String> users;
    Vertx vertxInstance;
    Duration timeout;
    Map<String, String> passwordGrantOptions;
    Map<String, String> clientCredGrantOptions;

    public OidcPasswordClientCredHandler(Vertx vertxInstance, Duration timeout, Map<String, Map<String, String>> grantOptions) {
        this(vertxInstance, timeout, Map.of(), grantOptions);
    }

    public OidcPasswordClientCredHandler(Vertx vertxInstance, Duration timeout, Map<String, String> users, Map<String, Map<String, String>> grantOptions) {
        this.vertxInstance = vertxInstance;
        this.timeout = timeout;
        this.users = users;
        this.passwordGrantOptions = grantOptions.get("password");
        this.clientCredGrantOptions = grantOptions.get("client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        String tokenUrl = form.get("tokenUrl");
        try (WebClient client = OidcDevServicesUtils.createWebClient(this.vertxInstance);){
            String token = null;
            if ("password".equals(form.get("grant"))) {
                LOG.infof("Using a password grant to get a token from '%s' for user '%s' with client id '%s'", (Object)tokenUrl, (Object)form.get("user"), (Object)form.get("client"));
                String userName = form.get("user");
                String password = this.users.get(userName);
                if (password == null || password.isBlank()) {
                    password = form.get("password");
                }
                token = OidcDevServicesUtils.getPasswordAccessToken(client, tokenUrl, form.get("client"), form.get("clientSecret"), userName, password, this.passwordGrantOptions, this.timeout);
            } else {
                LOG.infof("Using a client_credentials grant to get a token token from '%s' with client id '%s'", (Object)tokenUrl, (Object)form.get("client"));
                token = OidcDevServicesUtils.getClientCredAccessToken(client, tokenUrl, form.get("client"), form.get("clientSecret"), this.clientCredGrantOptions, this.timeout);
            }
            LOG.infof("Test token: %s", (Object)token);
            if (form.get("serviceUrl") != null) {
                this.testServiceInternal(event, client, form.get("serviceUrl"), token);
            } else {
                event.put("result", (Object)token);
            }
        }
    }

    private void testServiceInternal(RoutingContext event, WebClient client, String serviceUrl, String token) {
        try {
            LOG.infof("Sending token to '%s'", (Object)serviceUrl);
            int statusCode = ((HttpResponse)client.getAbs(serviceUrl).putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).send().await().indefinitely()).statusCode();
            LOG.infof("Result: %d", (Object)statusCode);
            event.put("result", (Object)String.valueOf(statusCode));
        }
        catch (Throwable t) {
            LOG.errorf("Token can not be sent to the service: %s", (Object)t.toString());
        }
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String result = (String)event.get("result");
        if (result != null) {
            event.response().end(result);
        }
    }
}

