/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesProcessor;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import org.jboss.logging.Logger;

public class KeycloakImplicitGrantPostHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(KeycloakImplicitGrantPostHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        try (WebClient client = KeycloakDevServicesUtils.createWebClient();){
            String token = form.get("token");
            LOG.infof("Test token: %s", (Object)token);
            LOG.infof("Sending token to '%s'", (Object)form.get("serviceUrl"));
            this.testServiceInternal(event, client, form.get("serviceUrl"), token);
        }
    }

    private void testServiceInternal(RoutingContext event, WebClient client, String serviceUrl, String token) {
        try {
            int statusCode = ((HttpResponse)client.getAbs(serviceUrl).putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).send().await().atMost(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout)).statusCode();
            LOG.infof("Result: %d", (Object)statusCode);
            event.put("result", (Object)String.valueOf(statusCode));
        }
        catch (Throwable t) {
            LOG.errorf("Token can not be sent to the service: %s", (Object)t.toString());
        }
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String result = (String)event.get("result");
        if (result != null) {
            event.response().end(result);
        }
    }
}

