/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesProcessor;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.util.Map;
import org.jboss.logging.Logger;

public class KeycloakDevConsolePostHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(KeycloakDevConsolePostHandler.class);
    Map<String, String> users;

    public KeycloakDevConsolePostHandler(Map<String, String> users) {
        this.users = users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        String tokenUrl = form.get("tokenUrl");
        try (WebClient client = OidcDevServicesUtils.createWebClient(KeycloakDevServicesProcessor.vertxInstance);){
            String token = null;
            if ("password".equals(form.get("grant"))) {
                LOG.infof("Using a password grant to get a token from '%s' for user '%s' with client id '%s'", (Object)tokenUrl, (Object)form.get("user"), (Object)form.get("client"));
                String userName = form.get("user");
                token = OidcDevServicesUtils.getPasswordAccessToken(client, tokenUrl, form.get("client"), form.get("clientSecret"), userName, this.users.get(userName), KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            } else {
                LOG.infof("Using a client_credentials grant to get a token token from '%s' with client id '%s'", (Object)tokenUrl, (Object)form.get("client"));
                token = OidcDevServicesUtils.getClientCredAccessToken(client, tokenUrl, form.get("client"), form.get("clientSecret"), KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            }
            LOG.infof("Test token: %s", (Object)token);
            if (form.get("serviceUrl") != null) {
                this.testServiceInternal(event, client, form.get("serviceUrl"), token);
            } else {
                event.put("result", (Object)token);
            }
        }
    }

    private void testServiceInternal(RoutingContext event, WebClient client, String serviceUrl, String token) {
        try {
            LOG.infof("Sending token to '%s'", (Object)serviceUrl);
            int statusCode = ((HttpResponse)client.getAbs(serviceUrl).putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).send().await().indefinitely()).statusCode();
            LOG.infof("Result: %d", (Object)statusCode);
            event.put("result", (Object)String.valueOf(statusCode));
        }
        catch (Throwable t) {
            LOG.errorf("Token can not be sent to the service: %s", (Object)t.toString());
        }
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String result = (String)event.get("result");
        if (result != null) {
            event.response().end(result);
        }
    }
}

