/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.oidc.runtime.OidcConfigPropertySupplier;
import io.vertx.core.Handler;
import java.util.function.Supplier;

public abstract class AbstractDevConsoleProcessor {
    protected static final String CONFIG_PREFIX = "quarkus.oidc.";
    protected static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    protected static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    protected static final String AUTHORIZATION_PATH_CONFIG_KEY = "quarkus.oidc.authorization-path";
    protected static final String TOKEN_PATH_CONFIG_KEY = "quarkus.oidc.token-path";
    protected static final String END_SESSION_PATH_CONFIG_KEY = "quarkus.oidc.end-session-path";
    protected static final String POST_LOGOUT_URI_PARAM_CONFIG_KEY = "quarkus.oidc.logout.post-logout-uri-param";
    protected static final String SCOPES_KEY = "quarkus.oidc.authentication.scopes";

    protected void produceDevConsoleTemplateItems(Capabilities capabilities, BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleTemplate, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeInfo, CurateOutcomeBuildItem curateOutcomeBuildItem, String oidcProviderName, String oidcApplicationType, String oidcGrantType, String authorizationUrl, String tokenUrl, String logoutUrl, boolean introspectionIsAvailable) {
        if (oidcProviderName != null) {
            devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcProviderName", (Object)oidcProviderName));
        }
        devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcApplicationType", (Object)oidcApplicationType));
        devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcGrantType", (Object)oidcGrantType));
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("swaggerIsAvailable", (Object)true));
        }
        if (capabilities.isPresent("io.quarkus.smallrye.graphql")) {
            devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("graphqlIsAvailable", (Object)true));
        }
        devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("introspectionIsAvailable", (Object)introspectionIsAvailable));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("clientId", (Supplier)new OidcConfigPropertySupplier(CLIENT_ID_CONFIG_KEY), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("clientSecret", (Supplier)new OidcConfigPropertySupplier(CLIENT_SECRET_CONFIG_KEY, ""), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("authorizationUrl", (Supplier)new OidcConfigPropertySupplier(AUTHORIZATION_PATH_CONFIG_KEY, authorizationUrl, true), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("tokenUrl", (Supplier)new OidcConfigPropertySupplier(TOKEN_PATH_CONFIG_KEY, tokenUrl, true), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("logoutUrl", (Supplier)new OidcConfigPropertySupplier(END_SESSION_PATH_CONFIG_KEY, logoutUrl, true), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("postLogoutUriParam", (Supplier)new OidcConfigPropertySupplier(POST_LOGOUT_URI_PARAM_CONFIG_KEY), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("scopes", (Supplier)new OidcConfigPropertySupplier(SCOPES_KEY), this.getClass(), curateOutcomeBuildItem));
    }

    protected void produceDevConsoleRouteItems(BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, DevConsolePostHandler testServiceWithToken, DevConsolePostHandler exchangeCodeForTokens, DevConsolePostHandler passwordClientCredHandler) {
        devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("testServiceWithToken", "POST", (Handler)testServiceWithToken));
        devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("exchangeCodeForTokens", "POST", (Handler)exchangeCodeForTokens));
        devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("testService", "POST", (Handler)passwordClientCredHandler));
    }
}

