/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevConsoleProcessor;
import io.quarkus.oidc.deployment.devservices.OidcAuthorizationCodePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.quarkus.oidc.deployment.devservices.OidcPasswordClientCredHandler;
import io.quarkus.oidc.deployment.devservices.OidcTestServiceHandler;
import io.quarkus.oidc.runtime.providers.KnownOidcProviders;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class OidcDevConsoleProcessor
extends AbstractDevConsoleProcessor {
    static volatile Vertx vertxInstance;
    private static final Logger LOG;
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String DISCOVERY_ENABLED_CONFIG_KEY = "quarkus.oidc.discovery-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String APP_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String OIDC_PROVIDER_CONFIG_KEY = "quarkus.oidc.provider";
    private static final String SERVICE_APP_TYPE = "service";
    private static final String KEYCLOAK = "Keycloak";
    private static final String AZURE = "Azure";
    private static final Set<String> OTHER_PROVIDERS;
    OidcBuildTimeConfig oidcConfig;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    void prepareOidcDevConsole(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleInfo, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeInfo, CuratedApplicationShutdownBuildItem closeBuildItem, BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, Capabilities capabilities, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!OidcDevConsoleProcessor.isOidcTenantEnabled() || !OidcDevConsoleProcessor.isClientIdSet()) {
            return;
        }
        OidcTenantConfig providerConfig = OidcDevConsoleProcessor.getProviderConfig();
        String authServerUrl = OidcDevConsoleProcessor.getAuthServerUrl(providerConfig);
        if (authServerUrl != null) {
            if (vertxInstance == null) {
                vertxInstance = Vertx.vertx();
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        if (vertxInstance != null) {
                            try {
                                vertxInstance.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to close Vertx instance", t);
                            }
                        }
                        vertxInstance = null;
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            JsonObject metadata = null;
            if (OidcDevConsoleProcessor.isDiscoveryEnabled(providerConfig) && (metadata = this.discoverMetadata(authServerUrl)) == null) {
                return;
            }
            String providerName = this.tryToGetProviderName(authServerUrl);
            if (KEYCLOAK.equals(providerName)) {
                devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakAdminUrl", (Object)authServerUrl.substring(0, authServerUrl.indexOf("/realms/"))));
            }
            this.produceDevConsoleTemplateItems(capabilities, devConsoleInfo, devConsoleRuntimeInfo, curateOutcomeBuildItem, providerName, OidcDevConsoleProcessor.getApplicationType(providerConfig), this.oidcConfig.devui.grant.type.isPresent() ? this.oidcConfig.devui.grant.type.get().getGrantType() : "code", metadata != null ? metadata.getString("authorization_endpoint") : null, metadata != null ? metadata.getString("token_endpoint") : null, metadata != null ? metadata.getString("end_session_endpoint") : null, metadata != null ? metadata.containsKey("introspection_endpoint") || metadata.containsKey("userinfo_endpoint") : this.checkProviderUserInfoRequired(providerConfig));
            this.produceDevConsoleRouteItems(devConsoleRoute, new OidcTestServiceHandler(vertxInstance, this.oidcConfig.devui.webClientTimeout), new OidcAuthorizationCodePostHandler(vertxInstance, this.oidcConfig.devui.webClientTimeout, this.oidcConfig.devui.grantOptions), new OidcPasswordClientCredHandler(vertxInstance, this.oidcConfig.devui.webClientTimeout, this.oidcConfig.devui.grantOptions));
        }
    }

    private boolean checkProviderUserInfoRequired(OidcTenantConfig providerConfig) {
        if (providerConfig != null) {
            return providerConfig.authentication.userInfoRequired.orElse(false);
        }
        return false;
    }

    private String tryToGetProviderName(String authServerUrl) {
        if (authServerUrl.contains("/realms/")) {
            return KEYCLOAK;
        }
        if (authServerUrl.contains("microsoft")) {
            return AZURE;
        }
        for (String provider : OTHER_PROVIDERS) {
            if (!authServerUrl.contains(provider.toLowerCase())) continue;
            return provider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject discoverMetadata(String authServerUrl) {
        try (WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);){
            String metadataUrl = authServerUrl + "/.well-known/openid-configuration";
            LOG.infof("OIDC Dev Console: discovering the provider metadata at %s", (Object)metadataUrl);
            HttpResponse resp = (HttpResponse)client.getAbs(metadataUrl).putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send().await().indefinitely();
            if (resp.statusCode() == 200) {
                JsonObject jsonObject = resp.bodyAsJsonObject();
                return jsonObject;
            }
            LOG.errorf("OIDC metadata discovery failed: %s", (Object)resp.bodyAsString());
            JsonObject jsonObject = null;
            return jsonObject;
        }
    }

    private static String getConfigProperty(String name) {
        return (String)ConfigProvider.getConfig().getValue(name, String.class);
    }

    private static boolean isOidcTenantEnabled() {
        return OidcDevConsoleProcessor.getBooleanProperty(TENANT_ENABLED_CONFIG_KEY);
    }

    private static boolean isDiscoveryEnabled(OidcTenantConfig providerConfig) {
        return ConfigProvider.getConfig().getOptionalValue(DISCOVERY_ENABLED_CONFIG_KEY, Boolean.class).orElse(providerConfig != null ? providerConfig.discoveryEnabled.orElse(true) : true);
    }

    private static boolean getBooleanProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, Boolean.class).orElse(true);
    }

    private static boolean isClientIdSet() {
        return ConfigUtils.isPropertyPresent((String)"quarkus.oidc.client-id");
    }

    private static String getAuthServerUrl(OidcTenantConfig providerConfig) {
        try {
            return OidcDevConsoleProcessor.getConfigProperty(AUTH_SERVER_URL_CONFIG_KEY);
        }
        catch (Exception ex) {
            return providerConfig != null ? (String)providerConfig.authServerUrl.get() : null;
        }
    }

    private static String getApplicationType(OidcTenantConfig providerConfig) {
        Optional appType = ConfigProvider.getConfig().getOptionalValue(APP_TYPE_CONFIG_KEY, OidcTenantConfig.ApplicationType.class);
        if (appType.isEmpty() && providerConfig != null) {
            appType = providerConfig.applicationType;
        }
        return appType.isPresent() ? ((OidcTenantConfig.ApplicationType)appType.get()).name().toLowerCase() : SERVICE_APP_TYPE;
    }

    private static OidcTenantConfig getProviderConfig() {
        try {
            OidcTenantConfig.Provider p = (OidcTenantConfig.Provider)ConfigProvider.getConfig().getValue(OIDC_PROVIDER_CONFIG_KEY, OidcTenantConfig.Provider.class);
            return KnownOidcProviders.provider((OidcTenantConfig.Provider)p);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        LOG = Logger.getLogger(OidcDevConsoleProcessor.class);
        OTHER_PROVIDERS = Set.of("Auth0", "Okta", "Google", "Github");
    }
}

