/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.deployment.QualifierRegistrarBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.AuthorizationCodeFlow;
import io.quarkus.oidc.BearerTokenAuthentication;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.Tenant;
import io.quarkus.oidc.TenantFeature;
import io.quarkus.oidc.TenantIdentityProvider;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.runtime.BackChannelLogoutHandler;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.DefaultTokenStateManager;
import io.quarkus.oidc.runtime.OidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcConfigurationMetadataProducer;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.oidc.runtime.OidcJsonWebTokenProducer;
import io.quarkus.oidc.runtime.OidcRecorder;
import io.quarkus.oidc.runtime.OidcSessionImpl;
import io.quarkus.oidc.runtime.OidcTokenCredentialProducer;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.providers.AzureAccessTokenCustomizer;
import io.quarkus.tls.TlsRegistryBuildItem;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorBindingBuildItem;
import io.quarkus.vertx.http.deployment.HttpAuthMechanismAnnotationBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={IsEnabled.class})
public class OidcBuildStep {
    private static final DotName CLAIM_NAME = DotName.createSimple((String)Claim.class.getName());
    private static final DotName CLAIM_VALUE_NAME = DotName.createSimple(ClaimValue.class);
    private static final DotName REQUEST_SCOPED_NAME = DotName.createSimple(RequestScoped.class);
    private static final Set<DotName> ALL_PROVIDER_NAMES = Set.of(DotNames.PROVIDER, DotNames.INSTANCE, DotNames.INJECTABLE_INSTANCE);
    private static final DotName TENANT_NAME = DotName.createSimple(Tenant.class);
    private static final DotName TENANT_FEATURE_NAME = DotName.createSimple(TenantFeature.class);
    private static final DotName TENANT_IDENTITY_PROVIDER_NAME = DotName.createSimple(TenantIdentityProvider.class);
    private static final Logger LOG = Logger.getLogger(OidcBuildStep.class);
    private static final DotName USER_INFO_NAME = DotName.createSimple(UserInfo.class);
    private static final DotName JSON_WEB_TOKEN_NAME = DotName.createSimple(JsonWebToken.class);
    private static final DotName ID_TOKEN_NAME = DotName.createSimple(IdToken.class);
    private static final String QUARKUS_TOKEN_PROPAGATION_PACKAGE = "io.quarkus.oidc.token.propagation";
    private static final String SMALLRYE_JWT_PACKAGE = "io.smallrye.jwt";

    @BuildStep
    public void provideSecurityInformation(BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.OPENIDCONNECT((String)"quarkus.oidc.auth-server-url"));
    }

    @BuildStep
    void checkClaim(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurator) {
        for (InjectionPointInfo injectionPoint : (Collection)beanRegistrationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            DotName scope;
            AnnotationInstance claimQualifier;
            if (injectionPoint.hasDefaultedQualifier() || (claimQualifier = injectionPoint.getRequiredQualifier(CLAIM_NAME)) == null) continue;
            Type actualType = injectionPoint.getRequiredType();
            Optional bean = injectionPoint.getTargetBean();
            if (!bean.isPresent() || REQUEST_SCOPED_NAME.equals((Object)(scope = ((BeanInfo)bean.get()).getScope().getDotName())) || ALL_PROVIDER_NAMES.contains(injectionPoint.getType().name()) || CLAIM_VALUE_NAME.equals((Object)actualType.name())) continue;
            String error = String.format("%s type can not be used to represent JWT claims in @Singleton or @ApplicationScoped beans, make the bean @RequestScoped or wrap this type with org.eclipse.microprofile.jwt.ClaimValue or jakarta.inject.Provider or jakarta.enterprise.inject.Instance", actualType.name());
            throw new IllegalStateException(error);
        }
    }

    @BuildStep
    AdditionalBeanBuildItem jwtClaimIntegration(Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.jwt")) {
            AdditionalBeanBuildItem.Builder removable = AdditionalBeanBuildItem.builder();
            removable.addBeanClass(CommonJwtProducer.class);
            removable.addBeanClass(RawClaimTypeProducer.class);
            removable.addBeanClass(JsonValueProducer.class);
            removable.addBeanClass(ClaimValueProducer.class);
            removable.addBeanClass(Claim.class);
            return removable.build();
        }
        return null;
    }

    @BuildStep
    public void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        builder.addBeanClass(OidcAuthenticationMechanism.class).addBeanClass(OidcJsonWebTokenProducer.class).addBeanClass(OidcTokenCredentialProducer.class).addBeanClass(OidcConfigurationMetadataProducer.class).addBeanClass(OidcIdentityProvider.class).addBeanClass(DefaultTenantConfigResolver.class).addBeanClass(DefaultTokenStateManager.class).addBeanClass(OidcSessionImpl.class).addBeanClass(BackChannelLogoutHandler.class).addBeanClass(AzureAccessTokenCustomizer.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep(onlyIf={IsCacheEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public SyntheticBeanBuildItem addDefaultCacheBean(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DefaultTokenIntrospectionUserInfoCache.class).unremovable()).types(new Class[]{DefaultTokenIntrospectionUserInfoCache.class, TokenIntrospectionCache.class, UserInfoCache.class})).supplier(recorder.setupTokenCache(config, vertxBuildItem.getVertx())).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.OIDC);
    }

    @BuildStep
    QualifierRegistrarBuildItem addQualifiers() {
        return new QualifierRegistrarBuildItem(new QualifierRegistrar(){

            public Map<DotName, Set<String>> getAdditionalQualifiers() {
                return Map.of(TENANT_FEATURE_NAME, Set.of());
            }
        });
    }

    @BuildStep
    InjectionPointTransformerBuildItem makeTenantIdentityProviderInjectionPointsNamed() {
        return new InjectionPointTransformerBuildItem(new InjectionPointsTransformer(){

            public boolean appliesTo(Type requiredType) {
                return requiredType.name().equals((Object)TENANT_IDENTITY_PROVIDER_NAME);
            }

            public void transform(InjectionPointsTransformer.TransformationContext ctx) {
                if (ctx.getTarget().kind() == AnnotationTarget.Kind.METHOD) {
                    ctx.getAllAnnotations().stream().filter(a -> TENANT_NAME.equals((Object)a.name())).forEach(a -> {
                        AnnotationValue[] annotationValue = new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)a.value().asString())};
                        ((InjectionPointsTransformer.Transformation)ctx.transform().add(AnnotationInstance.create((DotName)DotNames.NAMED, (AnnotationTarget)a.target(), (AnnotationValue[])annotationValue))).done();
                    });
                } else {
                    AnnotationInstance tenantAnnotation = Annotations.find((Collection)ctx.getAllAnnotations(), (DotName)TENANT_NAME);
                    if (tenantAnnotation != null && tenantAnnotation.value() != null) {
                        ((InjectionPointsTransformer.Transformation)ctx.transform().add(DotNames.NAMED, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)tenantAnnotation.value().asString())})).done();
                    }
                }
            }
        });
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void produceTenantIdentityProviders(BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, OidcRecorder recorder, BeanDiscoveryFinishedBuildItem beans, CombinedIndexBuildItem combinedIndex) {
        boolean createTenantIdentityProviderForDefaultTenant;
        if (!combinedIndex.getIndex().getAnnotations(TENANT_NAME).isEmpty()) {
            beans.getInjectionPoints().stream().filter(OidcBuildStep::isTenantIdentityProviderType).filter(ip -> ip.getRequiredQualifier(DotNames.NAMED) != null).map(ip -> ip.getRequiredQualifier(DotNames.NAMED).value().asString()).distinct().forEach(tenantName -> syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantIdentityProvider.class).named(tenantName)).scope(BuiltinScope.APPLICATION.getInfo())).supplier(recorder.createTenantIdentityProvider(tenantName)).unremovable()).done()));
        }
        if (createTenantIdentityProviderForDefaultTenant = beans.getInjectionPoints().stream().filter(ip -> ip.getRequiredQualifier(DotNames.NAMED) == null).anyMatch(OidcBuildStep::isTenantIdentityProviderType)) {
            syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantIdentityProvider.class).scope(BuiltinScope.APPLICATION.getInfo())).addQualifier(DotNames.DEFAULT)).alternative(true)).priority(1)).supplier(recorder.createTenantIdentityProvider("Default")).unremovable()).done());
        }
    }

    private static boolean isTenantIdentityProviderType(InjectionPointInfo ip) {
        return TENANT_IDENTITY_PROVIDER_NAME.equals((Object)ip.getRequiredType().name());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public SyntheticBeanBuildItem setup(BeanRegistrationPhaseBuildItem beanRegistration, OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem, TlsRegistryBuildItem tlsRegistryBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantConfigBean.class).unremovable()).types(new Class[]{TenantConfigBean.class})).supplier(recorder.createTenantConfigBean(config, vertxBuildItem.getVertx(), tlsRegistryBuildItem.registry(), OidcBuildStep.detectUserInfoRequired(beanRegistration))).destroyer(TenantConfigBean.Destroyer.class)).scope(Singleton.class)).setRuntimeInit().done();
    }

    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void initTenantConfigBean(OidcRecorder recorder) {
        recorder.initTenantConfigBean();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerTenantResolverInterceptor(Capabilities capabilities, OidcRecorder recorder, HttpBuildTimeConfig buildTimeConfig, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<EagerSecurityInterceptorBindingBuildItem> bindingProducer, BuildProducer<SystemPropertyBuildItem> systemPropertyProducer) {
        boolean foundTenantResolver;
        if (!buildTimeConfig.auth.proactive && (capabilities.isPresent("io.quarkus.resteasy.reactive") || capabilities.isPresent("io.quarkus.resteasy")) && (foundTenantResolver = combinedIndexBuildItem.getIndex().getAnnotations(TENANT_NAME).stream().map(AnnotationInstance::target).anyMatch(t -> OidcBuildStep.isMethodWithTenantAnnButNotInjPoint(t) || t.kind() == AnnotationTarget.Kind.CLASS))) {
            bindingProducer.produce((BuildItem)new EagerSecurityInterceptorBindingBuildItem(recorder.tenantResolverInterceptorCreator(), new DotName[]{TENANT_NAME}));
            systemPropertyProducer.produce((BuildItem)new SystemPropertyBuildItem("io.quarkus.oidc.runtime.select-tenants-with-annotation", Boolean.TRUE.toString()));
        }
    }

    private static boolean isMethodWithTenantAnnButNotInjPoint(AnnotationTarget t) {
        return t.kind() == AnnotationTarget.Kind.METHOD && !t.asMethod().isConstructor() && !t.hasAnnotation(DotNames.INJECT);
    }

    private static boolean detectUserInfoRequired(BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem) {
        return OidcBuildStep.isInjected(beanRegistrationPhaseBuildItem, USER_INFO_NAME, null);
    }

    @BuildStep
    void detectAccessTokenVerificationRequired(BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigDefaultProducer) {
        if (OidcBuildStep.isInjected(beanRegistrationPhaseBuildItem, JSON_WEB_TOKEN_NAME, ID_TOKEN_NAME)) {
            runtimeConfigDefaultProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.oidc.authentication.verify-access-token", "true"));
            runtimeConfigDefaultProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.oidc.*.authentication.verify-access-token", "true"));
        }
    }

    @BuildStep
    List<HttpAuthMechanismAnnotationBuildItem> registerHttpAuthMechanismAnnotation() {
        return List.of(new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(AuthorizationCodeFlow.class), "code"), new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(BearerTokenAuthentication.class), "Bearer"));
    }

    private static boolean isInjected(BeanRegistrationPhaseBuildItem beanRegistrationPhaseBuildItem, DotName requiredType, DotName withoutQualifier) {
        for (InjectionPointInfo injectionPoint : beanRegistrationPhaseBuildItem.getInjectionPoints()) {
            if (!requiredType.equals((Object)injectionPoint.getRequiredType().name()) || !OidcBuildStep.isApplicationPackage(injectionPoint.getTargetInfo()) || withoutQualifier != null && injectionPoint.getRequiredQualifier(withoutQualifier) != null) continue;
            LOG.debugf("%s injection point: %s", (Object)requiredType.toString(), (Object)injectionPoint.getTargetInfo());
            return true;
        }
        return false;
    }

    private static boolean isApplicationPackage(String injectionPointTargetInfo) {
        return injectionPointTargetInfo != null && !injectionPointTargetInfo.startsWith(QUARKUS_TOKEN_PROPAGATION_PACKAGE) && !injectionPointTargetInfo.startsWith(SMALLRYE_JWT_PACKAGE);
    }

    public static class IsCacheEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled && this.config.defaultTokenCacheEnabled;
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

