/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.oidc.runtime.OidcConfigPropertySupplier;
import io.quarkus.oidc.runtime.devui.OidcDevUiRecorder;
import io.quarkus.oidc.runtime.devui.OidcDevUiRpcSvcPropertiesBean;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.vertx.core.Handler;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractDevConsoleProcessor {
    protected static final String CONFIG_PREFIX = "quarkus.oidc.";
    protected static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    protected static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    protected static final String AUTHORIZATION_PATH_CONFIG_KEY = "quarkus.oidc.authorization-path";
    protected static final String TOKEN_PATH_CONFIG_KEY = "quarkus.oidc.token-path";
    protected static final String END_SESSION_PATH_CONFIG_KEY = "quarkus.oidc.end-session-path";
    protected static final String POST_LOGOUT_URI_PARAM_CONFIG_KEY = "quarkus.oidc.logout.post-logout-uri-param";
    protected static final String SCOPES_KEY = "quarkus.oidc.authentication.scopes";

    protected void produceDevConsoleTemplateItems(Capabilities capabilities, BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleTemplate, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeInfo, CurateOutcomeBuildItem curateOutcomeBuildItem, String oidcProviderName, String oidcApplicationType, String oidcGrantType, String authorizationUrl, String tokenUrl, String logoutUrl, boolean introspectionIsAvailable) {
        if (oidcProviderName != null) {
            devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcProviderName", (Object)oidcProviderName));
        }
        devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcApplicationType", (Object)oidcApplicationType));
        devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("oidcGrantType", (Object)oidcGrantType));
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("swaggerIsAvailable", (Object)true));
        }
        if (capabilities.isPresent("io.quarkus.smallrye.graphql")) {
            devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("graphqlIsAvailable", (Object)true));
        }
        devConsoleTemplate.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("introspectionIsAvailable", (Object)introspectionIsAvailable));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("clientId", (Supplier)new OidcConfigPropertySupplier(CLIENT_ID_CONFIG_KEY), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("clientSecret", (Supplier)new OidcConfigPropertySupplier(CLIENT_SECRET_CONFIG_KEY, ""), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("authorizationUrl", (Supplier)new OidcConfigPropertySupplier(AUTHORIZATION_PATH_CONFIG_KEY, authorizationUrl, true), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("tokenUrl", (Supplier)new OidcConfigPropertySupplier(TOKEN_PATH_CONFIG_KEY, tokenUrl, true), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("logoutUrl", (Supplier)new OidcConfigPropertySupplier(END_SESSION_PATH_CONFIG_KEY, logoutUrl, true), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("postLogoutUriParam", (Supplier)new OidcConfigPropertySupplier(POST_LOGOUT_URI_PARAM_CONFIG_KEY), this.getClass(), curateOutcomeBuildItem));
        devConsoleRuntimeInfo.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("scopes", (Supplier)new OidcConfigPropertySupplier(SCOPES_KEY), this.getClass(), curateOutcomeBuildItem));
    }

    protected void produceDevConsoleRouteItems(BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, DevConsolePostHandler testServiceWithToken, DevConsolePostHandler exchangeCodeForTokens, DevConsolePostHandler passwordClientCredHandler) {
        devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("testServiceWithToken", "POST", (Handler)testServiceWithToken));
        devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("exchangeCodeForTokens", "POST", (Handler)exchangeCodeForTokens));
        devConsoleRoute.produce((BuildItem)new DevConsoleRouteBuildItem("testService", "POST", (Handler)passwordClientCredHandler));
    }

    protected static CardPageBuildItem createProviderWebComponent(OidcDevUiRecorder recorder, Capabilities capabilities, String oidcProviderName, String oidcApplicationType, String oidcGrantType, String authorizationUrl, String tokenUrl, String logoutUrl, boolean introspectionIsAvailable, BuildProducer<SyntheticBeanBuildItem> beanProducer, Duration webClientTimeout, Map<String, Map<String, String>> grantOptions, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, ConfigurationBuildItem configurationBuildItem, String keycloakAdminUrl, Map<String, String> keycloakUsers, List<String> keycloakRealms, boolean alwaysLogoutUserInDevUiOnReload) {
        CardPageBuildItem cardPage = new CardPageBuildItem();
        cardPage.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:boxes-stacked")).title((String)(oidcProviderName == null ? "OpenId Connect Dev Console" : oidcProviderName + " provider"))).componentLink("qwc-oidc-provider.js"));
        boolean swaggerIsAvailable = capabilities.isPresent("io.quarkus.smallrye.openapi");
        boolean graphqlIsAvailable = capabilities.isPresent("io.quarkus.smallrye.graphql");
        String swaggerUiPath = swaggerIsAvailable ? nonApplicationRootPathBuildItem.resolvePath(AbstractDevConsoleProcessor.getProperty(configurationBuildItem, "quarkus.swagger-ui.path")) : null;
        String graphqlUiPath = graphqlIsAvailable ? nonApplicationRootPathBuildItem.resolvePath(AbstractDevConsoleProcessor.getProperty(configurationBuildItem, "quarkus.smallrye-graphql.ui.root-path")) : null;
        cardPage.addBuildTimeData("devRoot", (Object)nonApplicationRootPathBuildItem.getNonApplicationRootPath());
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OidcDevUiRpcSvcPropertiesBean.class).unremovable()).supplier(recorder.prepareRpcServiceProperties(authorizationUrl, tokenUrl, logoutUrl, webClientTimeout, grantOptions, keycloakUsers, oidcProviderName, oidcApplicationType, oidcGrantType, introspectionIsAvailable, keycloakAdminUrl, keycloakRealms, swaggerIsAvailable, graphqlIsAvailable, swaggerUiPath, graphqlUiPath, alwaysLogoutUserInDevUiOnReload)).scope(Singleton.class)).setRuntimeInit().done());
        return cardPage;
    }

    private static String getProperty(ConfigurationBuildItem configurationBuildItem, String propertyKey) {
        String propertyValue = (String)configurationBuildItem.getReadResult().getAllBuildTimeValues().get(propertyKey);
        if (propertyValue != null) {
            return propertyValue;
        }
        propertyValue = (String)configurationBuildItem.getReadResult().getBuildTimeRunTimeValues().get(propertyKey);
        if (propertyValue == null) {
            propertyValue = (String)configurationBuildItem.getReadResult().getRunTimeDefaultValues().get(propertyKey);
        }
        return propertyValue;
    }
}

