/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class DevServicesConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled = true;
    @ConfigItem(defaultValue="quay.io/keycloak/keycloak:22.0.5")
    public String imageName;
    @ConfigItem
    public Optional<Boolean> keycloakXImage;
    @ConfigItem(defaultValue="true")
    public boolean shared;
    @ConfigItem(defaultValue="quarkus")
    public String serviceName;
    @ConfigItem
    public Optional<List<String>> realmPath;
    @ConfigItem
    public Optional<String> javaOpts;
    @ConfigItem(defaultValue="false")
    public boolean showLogs;
    @ConfigItem
    public Optional<String> startCommand;
    @ConfigItem
    public Optional<String> realmName;
    @ConfigItem(defaultValue="true")
    public boolean createRealm;
    @ConfigItem
    public Map<String, String> users;
    @ConfigItem
    public Map<String, List<String>> roles;
    @Deprecated
    public Grant grant = new Grant();
    @ConfigItem
    public OptionalInt port;
    @ConfigItem
    public Map<String, String> containerEnv;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevServicesConfig that = (DevServicesConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.port, that.port) && Objects.equals(this.realmPath, that.realmPath) && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.users, that.users) && Objects.equals(this.javaOpts, that.javaOpts) && Objects.equals(this.roles, that.roles) && Objects.equals(this.containerEnv, that.containerEnv);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.imageName, this.port, this.realmPath, this.realmName, this.users, this.roles, this.containerEnv);
    }

    @ConfigGroup
    public static class Grant {
        @ConfigItem(defaultValue="code")
        public Type type = Type.CODE;

        public static enum Type {
            CLIENT("client_credentials"),
            PASSWORD("password"),
            CODE("code"),
            IMPLICIT("implicit");

            private String grantType;

            private Type(String grantType) {
                this.grantType = grantType;
            }

            public String getGrantType() {
                return this.grantType;
            }
        }
    }
}

